"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResourceFindingsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _findings_layout = require("../../layout/findings_layout");
var _findings_flyout = require("../../findings_flyout/findings_flyout");
var _utils = require("../../utils/utils");
var TEST_SUBJECTS = _interopRequireWildcard(require("../../test_subjects"));
var _empty_state = require("../../../../components/empty_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResourceFindingsTableComponent = ({
  items,
  loading,
  pagination,
  sorting,
  setTableOptions,
  onAddFilter,
  onOpenFlyout,
  flyoutFindingIndex,
  onPaginateFlyout,
  onCloseFlyout,
  onResetFilters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedFinding = items[flyoutFindingIndex];
  const getRowProps = row => ({
    style: (0, _utils.getSelectedRowStyle)(euiTheme, row, selectedFinding),
    'data-test-subj': TEST_SUBJECTS.getResourceFindingsTableRowTestId(row.resource.id)
  });
  const columns = (0, _react.useMemo)(() => [(0, _findings_layout.getExpandColumn)({
    onClick: onOpenFlyout
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['result.evaluation'], {
    onAddFilter
  }), _findings_layout.baseFindingsColumns['rule.benchmark.rule_number'], (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['rule.name'], {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['rule.section'], {
    onAddFilter
  }), _findings_layout.baseFindingsColumns['@timestamp']], [onAddFilter, onOpenFlyout]);
  if (!loading && !items.length) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": TEST_SUBJECTS.RESOURCES_FINDINGS_TABLE,
    loading: loading,
    items: items,
    columns: columns,
    onChange: setTableOptions,
    pagination: pagination,
    sorting: sorting,
    rowProps: getRowProps
  }), selectedFinding && /*#__PURE__*/_react.default.createElement(_findings_flyout.FindingsRuleFlyout, {
    findings: selectedFinding,
    onClose: onCloseFlyout,
    findingsCount: pagination.totalItemCount,
    flyoutIndex: flyoutFindingIndex + pagination.pageIndex * pagination.pageSize,
    onPaginate: onPaginateFlyout
  }));
};

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
const ResourceFindingsTable = /*#__PURE__*/_react.default.memo(ResourceFindingsTableComponent);
exports.ResourceFindingsTable = ResourceFindingsTable;