"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingTitle = exports.getDefaultQuery = exports.defaultGroupingOptions = exports.defaultColumns = exports.NULL_GROUPING_UNIT = exports.NULL_GROUPING_MESSAGES = exports.GROUPING_OPTIONS = exports.FINDINGS_UNIT = exports.DEFAULT_TABLE_HEIGHT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FINDINGS_UNIT = totalCount => _i18n.i18n.translate('xpack.csp.findings.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {finding} other {findings}}`
});
exports.FINDINGS_UNIT = FINDINGS_UNIT;
const GROUPING_OPTIONS = {
  RESOURCE_NAME: 'resource.name',
  RULE_NAME: 'rule.name',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  ORCHESTRATOR_CLUSTER_NAME: 'orchestrator.cluster.name'
};
exports.GROUPING_OPTIONS = GROUPING_OPTIONS;
const NULL_GROUPING_UNIT = _i18n.i18n.translate('xpack.csp.findings.grouping.nullGroupUnit', {
  defaultMessage: 'findings'
});
exports.NULL_GROUPING_UNIT = NULL_GROUPING_UNIT;
const NULL_GROUPING_MESSAGES = {
  RESOURCE_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.resource.nullGroupTitle', {
    defaultMessage: 'No resource'
  }),
  RULE_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.rule.nullGroupTitle', {
    defaultMessage: 'No rule'
  }),
  CLOUD_ACCOUNT_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.cloudAccount.nullGroupTitle', {
    defaultMessage: 'No cloud account'
  }),
  ORCHESTRATOR_CLUSTER_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.kubernetes.nullGroupTitle', {
    defaultMessage: 'No Kubernetes cluster'
  }),
  DEFAULT: _i18n.i18n.translate('xpack.csp.findings.grouping.default.nullGroupTitle', {
    defaultMessage: 'No grouping'
  })
};
exports.NULL_GROUPING_MESSAGES = NULL_GROUPING_MESSAGES;
const defaultGroupingOptions = [{
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByResource', {
    defaultMessage: 'Resource'
  }),
  key: GROUPING_OPTIONS.RESOURCE_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByRuleName', {
    defaultMessage: 'Rule name'
  }),
  key: GROUPING_OPTIONS.RULE_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByCloudAccount', {
    defaultMessage: 'Cloud account'
  }),
  key: GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByKubernetesCluster', {
    defaultMessage: 'Kubernetes cluster'
  }),
  key: GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME
}];
exports.defaultGroupingOptions = defaultGroupingOptions;
const groupingTitle = _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupBy', {
  defaultMessage: 'Group findings by'
});
exports.groupingTitle = groupingTitle;
const DEFAULT_TABLE_HEIGHT = 512;
exports.DEFAULT_TABLE_HEIGHT = DEFAULT_TABLE_HEIGHT;
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: [['@timestamp', 'desc']]
});
exports.getDefaultQuery = getDefaultQuery;
const defaultColumns = [{
  id: 'result.evaluation',
  width: 80
}, {
  id: 'resource.id'
}, {
  id: 'resource.name'
}, {
  id: 'resource.sub_type'
}, {
  id: 'rule.benchmark.rule_number'
}, {
  id: 'rule.name'
}, {
  id: 'rule.section'
}, {
  id: '@timestamp'
}];
exports.defaultColumns = defaultColumns;