"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudSecurityGrouping = void 0;
var _react = require("react");
var _securitysolutionGrouping = require("@kbn/securitysolution-grouping");
var uuid = _interopRequireWildcard(require("uuid"));
var _use_url_query = require("../../common/hooks/use_url_query");
var _use_cloud_posture_data_table = require("../../common/hooks/use_cloud_posture_data_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 10;
const GROUPING_ID = 'cspLatestFindings';
const MAX_GROUPING_LEVELS = 1;

/*
 Utility hook to handle the grouping logic of the cloud security components
*/
const useCloudSecurityGrouping = ({
  dataView,
  groupingTitle,
  defaultGroupingOptions,
  getDefaultQuery,
  unit,
  groupPanelRenderer,
  groupStatsRenderer
}) => {
  const getPersistedDefaultQuery = (0, _use_cloud_posture_data_table.usePersistedQuery)(getDefaultQuery);
  const {
    urlQuery,
    setUrlQuery
  } = (0, _use_url_query.useUrlQuery)(getPersistedDefaultQuery);
  const [activePageIndex, setActivePageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const {
    query,
    error
  } = (0, _use_cloud_posture_data_table.useBaseEsQuery)({
    dataView,
    filters: urlQuery.filters,
    query: urlQuery.query
  });

  /**
   * Reset the active page when the filters or query change
   * This is needed because the active page is not automatically reset when the filters or query change
   */
  (0, _react.useEffect)(() => {
    setActivePageIndex(0);
  }, [urlQuery.filters, urlQuery.query]);
  const grouping = (0, _securitysolutionGrouping.useGrouping)({
    componentProps: {
      unit,
      groupPanelRenderer,
      groupStatsRenderer
    },
    defaultGroupingOptions,
    fields: dataView.fields,
    groupingId: GROUPING_ID,
    maxGroupingLevels: MAX_GROUPING_LEVELS,
    title: groupingTitle,
    onGroupChange: () => {
      setActivePageIndex(0);
    }
  });
  const selectedGroup = grouping.selectedGroups[0];

  // This is recommended by the grouping component to cover an edge case
  // where the selectedGroup has multiple values
  const uniqueValue = (0, _react.useMemo)(() => `${selectedGroup}-${uuid.v4()}`, [selectedGroup]);
  const isNoneSelected = (0, _securitysolutionGrouping.isNoneGroup)(grouping.selectedGroups);
  const onChangeGroupsItemsPerPage = size => {
    setActivePageIndex(0);
    setPageSize(size);
  };
  const onResetFilters = (0, _react.useCallback)(() => {
    setUrlQuery({
      filters: [],
      query: {
        query: '',
        language: 'kuery'
      }
    });
  }, [setUrlQuery]);
  const onChangeGroupsPage = index => setActivePageIndex(index);
  return {
    activePageIndex,
    grouping,
    pageSize,
    query,
    error,
    selectedGroup,
    setUrlQuery,
    uniqueValue,
    isNoneSelected,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    onResetFilters,
    filters: urlQuery.filters
  };
};
exports.useCloudSecurityGrouping = useCloudSecurityGrouping;