"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fields_selector = require("./fields_selector");
var _use_styles = require("./use_styles");
var _get_abbreviated_number = require("../../common/utils/get_abbreviated_number");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupSelectorWrapper = ({
  children
}) => {
  const styles = (0, _use_styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: styles.groupBySelector
  }, children);
};
const AdditionalControls = ({
  total,
  title,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn,
  groupSelectorComponent
}) => {
  const [isFieldSelectorModalVisible, setIsFieldSelectorModalVisible] = (0, _react.useState)(false);
  const closeModal = () => setIsFieldSelectorModalVisible(false);
  const showModal = () => setIsFieldSelectorModalVisible(true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFieldSelectorModalVisible && /*#__PURE__*/_react.default.createElement(_fields_selector.FieldsSelectorModal, {
    columns: columns,
    dataView: dataView,
    closeModal: closeModal,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "cspDataTableTotal"
  }, `${(0, _get_abbreviated_number.getAbbreviatedNumber)(total)} ${title}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "cspDataTableFields",
    iconType: "tableOfContents",
    onClick: showModal,
    size: "xs",
    color: "text"
  }, _i18n.i18n.translate('xpack.csp.dataTable.fields', {
    defaultMessage: 'Fields'
  }))), groupSelectorComponent && /*#__PURE__*/_react.default.createElement(GroupSelectorWrapper, null, groupSelectorComponent));
};
exports.AdditionalControls = AdditionalControls;