"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaginationTableParams = exports.getPaginationQuery = exports.getDefaultQuery = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPaginationTableParams = (params, pageSizeOptions = [10, 25, 100], showPerPageOptions = true) => ({
  ...params,
  pageSizeOptions,
  showPerPageOptions
});
exports.getPaginationTableParams = getPaginationTableParams;
const getPaginationQuery = ({
  pageIndex,
  pageSize
}) => ({
  from: pageIndex * pageSize,
  size: pageSize
});
exports.getPaginationQuery = getPaginationQuery;
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: {
    field: '@timestamp',
    direction: 'desc'
  },
  pageIndex: 0
});
exports.getDefaultQuery = getDefaultQuery;