"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useThemeDarkmodeToggle = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useThemeDarkmodeToggle = ({
  uiSettingsClient
}) => {
  const [isDarkModeOn, setIsDarkModeOn] = (0, _react.useState)(false);
  // If a value is set in kibana.yml (uiSettings.overrides.theme:darkMode)
  // we don't allow the user to change the theme color.
  const valueSetInKibanaConfig = uiSettingsClient.isOverridden('theme:darkMode');
  const {
    userProfileData,
    isLoading,
    update
  } = (0, _userProfileComponents.useUpdateUserProfile)({
    notificationSuccess: {
      title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.darkMode.successNotificationTitle', {
        defaultMessage: 'Color theme updated'
      }),
      pageReloadText: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.darkMode.successNotificationText', {
        defaultMessage: 'Reload the page to see the changes'
      })
    },
    pageReloadChecker: (prev, next) => {
      var _prev$userSettings, _next$userSettings;
      return (prev === null || prev === void 0 ? void 0 : (_prev$userSettings = prev.userSettings) === null || _prev$userSettings === void 0 ? void 0 : _prev$userSettings.darkMode) !== ((_next$userSettings = next.userSettings) === null || _next$userSettings === void 0 ? void 0 : _next$userSettings.darkMode);
    }
  });
  const {
    userSettings: {
      darkMode: colorScheme
    } = {
      darkMode: undefined
    }
  } = userProfileData !== null && userProfileData !== void 0 ? userProfileData : {};
  const toggle = (0, _react.useCallback)(on => {
    if (isLoading) {
      return;
    }
    update({
      userSettings: {
        darkMode: on ? 'dark' : 'light'
      }
    });
  }, [isLoading, update]);
  (0, _react.useEffect)(() => {
    let updatedValue = false;
    if (typeof colorScheme !== 'string') {
      var _uiSettingsClient$get;
      // User profile does not have yet any preference -> default to space dark mode value
      updatedValue = (_uiSettingsClient$get = uiSettingsClient.get('theme:darkMode')) !== null && _uiSettingsClient$get !== void 0 ? _uiSettingsClient$get : false;
    } else {
      updatedValue = colorScheme === 'dark';
    }
    setIsDarkModeOn(updatedValue);
  }, [colorScheme, uiSettingsClient]);
  return {
    isVisible: valueSetInKibanaConfig ? false : Boolean(userProfileData),
    toggle,
    isDarkModeOn,
    colorScheme
  };
};
exports.useThemeDarkmodeToggle = useThemeDarkmodeToggle;