"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectorConditionsMap = exports.DefaultProcessSelector = exports.DefaultProcessResponse = exports.DefaultFileSelector = exports.DefaultFileResponse = void 0;
var i18n = _interopRequireWildcard(require("./components/control_general_view/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * cloud_defend plugin types
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

/**
 * cloud_defend/control types
 */

/*
 * 'stringArray' uses a EuiComboBox
 * 'flag' is a boolean value which is always 'true'
 * 'boolean' can be true or false
 */

// used to determine UX control and allowed values for each condition
const SelectorConditionsMap = {
  containerImageFullName: {
    type: 'stringArray',
    pattern: '^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9-](?:\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$',
    patternError: i18n.errorInvalidFullContainerImageName,
    not: ['containerImageName']
  },
  containerImageName: {
    type: 'stringArray',
    pattern: '^([a-z0-9]+(?:[._-][a-z0-9]+)*)$',
    not: ['containerImageFullName']
  },
  containerImageTag: {
    type: 'stringArray'
  },
  kubernetesClusterId: {
    type: 'stringArray'
  },
  kubernetesClusterName: {
    type: 'stringArray'
  },
  kubernetesNamespace: {
    type: 'stringArray'
  },
  kubernetesPodName: {
    type: 'stringArray'
  },
  kubernetesPodLabel: {
    type: 'stringArray',
    pattern: '^([a-zA-Z0-9\\.\\-]+\\/)?[a-zA-Z0-9\\.\\-]+:[a-zA-Z0-9\\.\\-\\_]*\\*?$',
    patternError: i18n.errorInvalidPodLabel
  },
  operation: {
    type: 'stringArray',
    values: {
      file: ['createExecutable', 'modifyExecutable', 'createFile', 'modifyFile', 'deleteFile'],
      process: ['fork', 'exec']
    }
  },
  targetFilePath: {
    selectorType: 'file',
    type: 'stringArray',
    maxValueBytes: 255,
    pattern: '^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$',
    patternError: i18n.errorInvalidTargetFilePath
  },
  ignoreVolumeFiles: {
    selectorType: 'file',
    type: 'flag',
    not: ['ignoreVolumeMounts']
  },
  ignoreVolumeMounts: {
    selectorType: 'file',
    type: 'flag',
    not: ['ignoreVolumeFiles']
  },
  processExecutable: {
    selectorType: 'process',
    type: 'stringArray',
    not: ['processName'],
    pattern: '^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$',
    patternError: i18n.errorInvalidProcessExecutable
  },
  processName: {
    selectorType: 'process',
    type: 'stringArray',
    not: ['processExecutable'],
    maxValueBytes: 15
  },
  sessionLeaderInteractive: {
    selectorType: 'process',
    type: 'boolean'
  }
};
exports.SelectorConditionsMap = SelectorConditionsMap;
const DefaultFileSelector = {
  type: 'file',
  name: 'Untitled',
  operation: ['createExecutable', 'modifyExecutable']
};
exports.DefaultFileSelector = DefaultFileSelector;
const DefaultProcessSelector = {
  type: 'process',
  name: 'Untitled',
  operation: ['fork', 'exec']
};
exports.DefaultProcessSelector = DefaultProcessSelector;
const DefaultFileResponse = {
  type: 'file',
  match: [],
  actions: ['alert']
};
exports.DefaultFileResponse = DefaultFileResponse;
const DefaultProcessResponse = {
  type: 'process',
  match: [],
  actions: ['alert']
};
exports.DefaultProcessResponse = DefaultProcessResponse;