"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ColorPickerLazy: true,
  ColorPicker: true,
  LegendToggleLazy: true,
  LegendToggle: true,
  CurrentTime: true,
  EmptyPlaceholder: true,
  useCommonChartStyles: true
};
exports.ColorPickerLazy = exports.ColorPicker = void 0;
Object.defineProperty(exports, "CurrentTime", {
  enumerable: true,
  get: function () {
    return _current_time.CurrentTime;
  }
});
Object.defineProperty(exports, "EmptyPlaceholder", {
  enumerable: true,
  get: function () {
    return _empty_placeholder.EmptyPlaceholder;
  }
});
exports.LegendToggleLazy = exports.LegendToggle = void 0;
Object.defineProperty(exports, "useCommonChartStyles", {
  enumerable: true,
  get: function () {
    return _common_chart_styles.useCommonChartStyles;
  }
});
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _current_time = require("./current_time");
var _empty_placeholder = require("./empty_placeholder");
var _common_chart_styles = require("./common_chart_styles");
var _endzones = require("./endzones");
Object.keys(_endzones).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _endzones[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _endzones[key];
    }
  });
});
var _warnings = require("./warnings");
Object.keys(_warnings).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _warnings[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _warnings[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * The Lazily-loaded `ColorPicker` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const ColorPickerLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./color_picker'))).then(({
  ColorPicker
}) => ({
  default: ColorPicker
})));

/**
 * A `ColorPicker` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `ColorPickerLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.ColorPickerLazy = ColorPickerLazy;
const ColorPicker = (0, _sharedUxUtility.withSuspense)(ColorPickerLazy);

/**
 * The Lazily-loaded `LegendToggle` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
exports.ColorPicker = ColorPicker;
const LegendToggleLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./legend_toggle'))).then(({
  LegendToggle
}) => ({
  default: LegendToggle
})));

/**
 * A `LegendToggle` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `LegendToggleLazy` component lazily with
 * a predefined fallback and error boundary.
 */
exports.LegendToggleLazy = LegendToggleLazy;
const LegendToggle = (0, _sharedUxUtility.withSuspense)(LegendToggleLazy);
exports.LegendToggle = LegendToggle;