"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusTotalsByType = getStatusTotalsByType;
var _api = require("../../../common/types/api");
var _api2 = require("../../../common/api");
var _authorization = require("../../authorization");
var _utils = require("../utils");
var _error = require("../../common/error");
var _runtime_types = require("../../../common/api/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getStatusTotalsByType(params, clientArgs) {
  const {
    services: {
      caseService
    },
    logger,
    authorization
  } = clientArgs;
  try {
    const queryParams = (0, _api2.decodeWithExcessOrThrow)(_api.CasesStatusRequestRt)(params);
    const {
      filter: authorizationFilter
    } = await authorization.getAuthorizationFilter(_authorization.Operations.getCaseStatuses);
    const options = (0, _utils.constructQueryOptions)({
      owner: queryParams.owner,
      from: queryParams.from,
      to: queryParams.to,
      authorizationFilter
    });
    const statusStats = await caseService.getCaseStatusStats({
      searchOptions: options
    });
    const res = {
      count_open_cases: statusStats.open,
      count_in_progress_cases: statusStats['in-progress'],
      count_closed_cases: statusStats.closed
    };
    return (0, _runtime_types.decodeOrThrow)(_api.CasesStatusResponseRt)(res);
  } catch (error) {
    throw (0, _error.createCaseError)({
      message: `Failed to get status stats: ${error}`,
      error,
      logger
    });
  }
}