"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_DARK_MODE = exports.ActionWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_is_dark_theme = require("../../../common/use_is_dark_theme");
var _common2 = require("../../../../common");
var _kibana = require("../../../common/lib/kibana");
var _cases_context = _interopRequireDefault(require("../../cases_context"));
var _owner = require("../../../../common/utils/owner");
var _can_use_cases = require("../../../client/helpers/can_use_cases");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DARK_MODE = 'theme:darkMode';
exports.DEFAULT_DARK_MODE = DEFAULT_DARK_MODE;
const ActionWrapperWithContext = ({
  children,
  caseContextProps,
  currentAppId
}) => {
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const isDarkTheme = (0, _use_is_dark_theme.useIsDarkTheme)();
  const owner = (0, _owner.getCaseOwnerByAppId)(currentAppId);
  const casePermissions = (0, _can_use_cases.canUseCases)(application.capabilities)(owner ? [owner] : undefined);
  // TODO: Remove when https://github.com/elastic/kibana/issues/143201 is developed
  const syncAlerts = owner === _common2.SECURITY_SOLUTION_OWNER;
  return /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkTheme
  }, /*#__PURE__*/_react.default.createElement(_cases_context.default, {
    value: {
      ...caseContextProps,
      owner: owner ? [owner] : [],
      permissions: casePermissions,
      features: {
        alerts: {
          sync: syncAlerts
        }
      }
    }
  }, children));
};
ActionWrapperWithContext.displayName = 'ActionWrapperWithContext';
const ActionWrapperComponent = ({
  core,
  plugins,
  storage,
  history,
  children,
  caseContextProps,
  currentAppId
}) => {
  return /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(ActionWrapperWithContext, {
    caseContextProps: caseContextProps,
    currentAppId: currentAppId
  }, children)));
};
ActionWrapperComponent.displayName = 'ActionWrapper';
const ActionWrapper = /*#__PURE__*/_react.default.memo(ActionWrapperComponent);
exports.ActionWrapper = ActionWrapper;