"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  REMOVE_ASSIGNEE: true,
  REMOVE_ASSIGNEE_ARIA_LABEL: true,
  MISSING_PROFILE: true,
  SEARCH_USERS: true,
  EDIT_ASSIGNEES: true,
  REMOVE_ASSIGNEES: true,
  ASSIGNEES: true,
  USER_DOES_NOT_EXIST: true,
  LEARN_PRIVILEGES_GRANT_ACCESS: true,
  MODIFY_SEARCH: true,
  INVALID_ASSIGNEES: true,
  MAX_SELECTED_ASSIGNEES: true
};
exports.USER_DOES_NOT_EXIST = exports.SEARCH_USERS = exports.REMOVE_ASSIGNEE_ARIA_LABEL = exports.REMOVE_ASSIGNEES = exports.REMOVE_ASSIGNEE = exports.MODIFY_SEARCH = exports.MISSING_PROFILE = exports.MAX_SELECTED_ASSIGNEES = exports.LEARN_PRIVILEGES_GRANT_ACCESS = exports.INVALID_ASSIGNEES = exports.EDIT_ASSIGNEES = exports.ASSIGNEES = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REMOVE_ASSIGNEE = _i18n.i18n.translate('xpack.cases.userProfile.removeAssigneeToolTip', {
  defaultMessage: 'Remove assignee'
});
exports.REMOVE_ASSIGNEE = REMOVE_ASSIGNEE;
const REMOVE_ASSIGNEE_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.userProfile.removeAssigneeAriaLabel', {
  defaultMessage: 'click to remove assignee'
});
exports.REMOVE_ASSIGNEE_ARIA_LABEL = REMOVE_ASSIGNEE_ARIA_LABEL;
const MISSING_PROFILE = _i18n.i18n.translate('xpack.cases.userProfile.missingProfile', {
  defaultMessage: 'Unable to find user profile'
});
exports.MISSING_PROFILE = MISSING_PROFILE;
const SEARCH_USERS = _i18n.i18n.translate('xpack.cases.userProfile.selectableSearchPlaceholder', {
  defaultMessage: 'Search users'
});
exports.SEARCH_USERS = SEARCH_USERS;
const EDIT_ASSIGNEES = _i18n.i18n.translate('xpack.cases.userProfile.editAssignees', {
  defaultMessage: 'Edit assignees'
});
exports.EDIT_ASSIGNEES = EDIT_ASSIGNEES;
const REMOVE_ASSIGNEES = _i18n.i18n.translate('xpack.cases.userProfile.suggestUsers.removeAssignees', {
  defaultMessage: 'Remove all assignees'
});
exports.REMOVE_ASSIGNEES = REMOVE_ASSIGNEES;
const ASSIGNEES = _i18n.i18n.translate('xpack.cases.userProfile.assigneesTitle', {
  defaultMessage: 'Assignees'
});
exports.ASSIGNEES = ASSIGNEES;
const USER_DOES_NOT_EXIST = _i18n.i18n.translate('xpack.cases.userProfiles.userDoesNotExist', {
  defaultMessage: "User doesn't exist or is unavailable"
});
exports.USER_DOES_NOT_EXIST = USER_DOES_NOT_EXIST;
const LEARN_PRIVILEGES_GRANT_ACCESS = _i18n.i18n.translate('xpack.cases.userProfiles.learnPrivileges', {
  defaultMessage: 'Learn what privileges grant access to cases.'
});
exports.LEARN_PRIVILEGES_GRANT_ACCESS = LEARN_PRIVILEGES_GRANT_ACCESS;
const MODIFY_SEARCH = _i18n.i18n.translate('xpack.cases.userProfiles.modifySearch', {
  defaultMessage: "Modify your search or check the user's privileges."
});
exports.MODIFY_SEARCH = MODIFY_SEARCH;
const INVALID_ASSIGNEES = _i18n.i18n.translate('xpack.cases.create.invalidAssignees', {
  defaultMessage: 'You cannot assign more than {maxAssignees} assignees to a case.',
  values: {
    maxAssignees: _constants.MAX_ASSIGNEES_PER_CASE
  }
});
exports.INVALID_ASSIGNEES = INVALID_ASSIGNEES;
const MAX_SELECTED_ASSIGNEES = limit => _i18n.i18n.translate('xpack.cases.userProfile.maxSelectedAssignees', {
  defaultMessage: "You've selected the maximum number of {count, plural, one {# assignee} other {# assignees}}",
  values: {
    count: limit
  }
});
exports.MAX_SELECTED_ASSIGNEES = MAX_SELECTED_ASSIGNEES;