"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DELETE_ATTACHMENT: true,
  REMOVE_ALERTS: true,
  REMOVE: true
};
exports.REMOVE_ALERTS = exports.REMOVE = exports.DELETE_ATTACHMENT = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_ATTACHMENT = _i18n.i18n.translate('xpack.cases.userActions.deleteAttachment', {
  defaultMessage: 'Delete attachment'
});
exports.DELETE_ATTACHMENT = DELETE_ATTACHMENT;
const REMOVE_ALERTS = totalAlerts => _i18n.i18n.translate('xpack.cases.caseView.alerts.removeAlerts', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Remove {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.REMOVE_ALERTS = REMOVE_ALERTS;
const REMOVE = _i18n.i18n.translate('xpack.cases.caseView.alerts.remove', {
  defaultMessage: 'Remove'
});
exports.REMOVE = REMOVE;