"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _config = require("./config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusStatsComponent = ({
  caseCount,
  caseStatus,
  isLoading,
  dataTestSubj
}) => {
  const statusStats = (0, _react.useMemo)(() => [{
    title: _config.statuses[caseStatus].stats.title,
    description: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": `${dataTestSubj}-loading-spinner`
    }) : caseCount !== null && caseCount !== void 0 ? caseCount : '-'
  }], [caseCount, caseStatus, dataTestSubj, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": dataTestSubj,
    textStyle: "reverse",
    listItems: statusStats
  });
};
StatusStatsComponent.displayName = 'StatusStats';
const StatusStats = /*#__PURE__*/(0, _react.memo)(StatusStatsComponent);
exports.StatusStats = StatusStats;