"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentCasesComp = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _localized_date_tooltip = require("../localized_date_tooltip");
var _icon_with_count = require("./icon_with_count");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _loading_placeholders = require("./loading_placeholders");
var _no_cases = require("./no_cases");
var _truncated_text = require("../truncated_text");
var _markdown_editor = require("../markdown_editor");
var _use_get_cases = require("../../containers/use_get_cases");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MarkdownContainer = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    max-height: 150px;
    overflow-y: auto;
    color: ${theme.eui.euiTextSubduedColor};
  `}
`;
const TruncateComp = _styledComponents.default.div`
  & .euiMarkdownFormat {
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
    word-break: break-word;
  }
`;
const RecentCasesComp = /*#__PURE__*/_react.default.memo(({
  filterOptions,
  maxCasesToShow,
  recentCasesFilterBy
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)(['read']);
  const hasOwner = !!owner.length;
  const {
    data = _use_get_cases.initialData,
    isLoading: isLoadingCases
  } = (0, _use_get_cases.useGetCases)({
    queryParams: {
      perPage: maxCasesToShow
    },
    filterOptions: {
      ...filterOptions,
      owner: hasOwner ? owner : availableSolutions
    }
  });
  return isLoadingCases ? /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
    lines: 2,
    placeholders: 3
  }) : !isLoadingCases && data.cases.length === 0 ? /*#__PURE__*/_react.default.createElement(_no_cases.NoCases, {
    recentCasesFilterBy: recentCasesFilterBy
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.cases.map((c, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: c.id,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: c.id,
    title: c.title
  }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
    text: c.title
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), c.description && c.description.length && /*#__PURE__*/_react.default.createElement(MarkdownContainer, null, /*#__PURE__*/_react.default.createElement(TruncateComp, null, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, {
    disableLinks: true,
    textSize: "relative"
  }, c.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "default",
    "data-test-subj": "recent-cases-creation-relative-time"
  }, /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
    date: new Date(c.createdAt)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: c.createdAt
  })))), /*#__PURE__*/_react.default.createElement(_icon_with_count.IconWithCount, {
    count: c.totalComment,
    icon: 'editorComment',
    tooltip: i18n.COMMENTS
  })), i !== data.cases.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })))));
});
exports.RecentCasesComp = RecentCasesComp;
RecentCasesComp.displayName = 'RecentCasesComp';