"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _links = require("../../links");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _navigation = require("../../../common/navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoCasesComponent = ({
  recentCasesFilterBy
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToCreateCase();
  }, [navigateToCreateCase]);
  const getNoCasesMessage = () => {
    if (recentCasesFilterBy === 'myRecentlyAssigned') {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "no-cases-assigned-to-me"
      }, i18n.NO_CASES_ASSIGNED_TO_ME);
    }
    return permissions.create ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, i18n.NO_CASES), /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
      "data-test-subj": "no-cases-create-case",
      onClick: navigateToCreateCaseClick,
      href: getCreateCaseUrl()
    }, ` ${i18n.START_A_NEW_CASE}`), '!') : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "no-cases-readonly"
    }, i18n.NO_CASES_READ_ONLY);
  };
  return getNoCasesMessage();
};
NoCasesComponent.displayName = 'NoCasesComponent';
const NoCases = /*#__PURE__*/_react.default.memo(NoCasesComponent);
exports.NoCases = NoCases;