"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensButtonToggle = void 0;
var _lodash = require("lodash");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react = require("react");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-non-null-assertion */

const DISABLED_CLASSNAME = 'euiButtonIcon-isDisabled';
const useLensButtonToggle = ({
  astRef,
  editorRef,
  uiPlugins,
  value
}) => {
  const lensPluginAvailable = (0, _react.useRef)(false);
  const [lensNodeSelected, setLensNodeSelected] = (0, _react.useState)(false);
  const enableLensButton = (0, _react.useCallback)(() => {
    var _editorRef$current, _editorRef$current2;
    if (editorRef !== null && editorRef !== void 0 && (_editorRef$current = editorRef.current) !== null && _editorRef$current !== void 0 && _editorRef$current.textarea && (_editorRef$current2 = editorRef.current) !== null && _editorRef$current2 !== void 0 && _editorRef$current2.toolbar) {
      var _editorRef$current3, _editorRef$current3$t;
      const lensPluginButton = (_editorRef$current3 = editorRef.current) === null || _editorRef$current3 === void 0 ? void 0 : (_editorRef$current3$t = _editorRef$current3.toolbar) === null || _editorRef$current3$t === void 0 ? void 0 : _editorRef$current3$t.querySelector(`[aria-label="${_translations.VISUALIZATION}"]`);
      if (lensPluginButton) {
        const isDisabled = lensPluginButton.className.includes(DISABLED_CLASSNAME);
        const buttonStyle = lensPluginButton.getAttribute('style');
        if (isDisabled && buttonStyle) {
          lensPluginButton.className = lensPluginButton.className.replace(DISABLED_CLASSNAME, '');
          lensPluginButton.setAttribute('style', buttonStyle.replace('pointer-events: none;', ''));
        }
      }
    }
  }, [editorRef]);
  const disableLensButton = (0, _react.useCallback)(() => {
    var _editorRef$current4;
    if (editorRef !== null && editorRef !== void 0 && (_editorRef$current4 = editorRef.current) !== null && _editorRef$current4 !== void 0 && _editorRef$current4.textarea && editorRef.current.toolbar) {
      var _editorRef$current$to;
      const lensPluginButton = (_editorRef$current$to = editorRef.current.toolbar) === null || _editorRef$current$to === void 0 ? void 0 : _editorRef$current$to.querySelector(`[aria-label="${_translations.VISUALIZATION}"]`);
      if (lensPluginButton) {
        const isDisabled = lensPluginButton.className.includes(DISABLED_CLASSNAME);
        if (!isDisabled) {
          lensPluginButton.className += ` ${DISABLED_CLASSNAME}`;
          lensPluginButton.setAttribute('style', 'pointer-events: none;');
        }
      }
    }
  }, [editorRef]);
  (0, _react.useEffect)(() => {
    lensPluginAvailable.current = (0, _lodash.some)(uiPlugins, ['name', 'lens']);
  }, [uiPlugins]);
  (0, _useDebounce.default)(() => {
    if (lensNodeSelected || !(value !== null && value !== void 0 && value.includes(_constants.PREFIX))) {
      enableLensButton();
    } else {
      disableLensButton();
    }
  }, 100, [value, lensNodeSelected]);

  // Copied from https://github.com/elastic/eui/blob/master/src/components/markdown_editor/markdown_editor.tsx#L279
  (0, _react.useEffect)(() => {
    var _editorRef$current5, _editorRef$current7;
    if ((editorRef === null || editorRef === void 0 ? void 0 : (_editorRef$current5 = editorRef.current) === null || _editorRef$current5 === void 0 ? void 0 : _editorRef$current5.textarea) == null || (astRef === null || astRef === void 0 ? void 0 : astRef.current) == null || !lensPluginAvailable.current) {
      return;
    }
    const getCursorNode = () => {
      var _editorRef$current6;
      const {
        selectionStart
      } = (_editorRef$current6 = editorRef.current) === null || _editorRef$current6 === void 0 ? void 0 : _editorRef$current6.textarea;
      let node = astRef.current;
      outer: while (true) {
        if (node.children) {
          for (let i = 0; i < node.children.length; i++) {
            const child = node.children[i];
            if (child.position && child.position.start.offset < selectionStart && selectionStart < child.position.end.offset) {
              if (child.type === 'text') break outer; // don't dive into `text` nodes
              node = child;
              // eslint-disable-next-line no-continue
              continue outer;
            }
          }
        }
        break;
      }
      setLensNodeSelected(node.type === 'lens');
    };
    const textarea = (_editorRef$current7 = editorRef.current) === null || _editorRef$current7 === void 0 ? void 0 : _editorRef$current7.textarea;
    textarea.addEventListener('keyup', getCursorNode);
    textarea.addEventListener('mouseup', getCursorNode);
    return () => {
      textarea.removeEventListener('keyup', getCursorNode);
      textarea.removeEventListener('mouseup', getCursorNode);
    };
  }, [astRef, editorRef]);
};
exports.useLensButtonToggle = useLensButtonToggle;