"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocalizedDateTooltip = void 0;
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocalizedDateTooltip = /*#__PURE__*/_react.default.memo(({
  children,
  date,
  fieldName,
  className = ''
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": "localized-date-tool-tip",
  anchorClassName: className,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "dates-container",
    direction: "column",
    gutterSize: "none"
  }, fieldName != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "field-name"
  }, fieldName)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "with-day-of-week",
    grow: false
  }, _momentTimezone.default.tz(date, (0, _kibana.useTimeZone)()).format('llll')))
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
exports.LocalizedDateTooltip = LocalizedDateTooltip;
LocalizedDateTooltip.displayName = 'LocalizedDateTooltip';