"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldsForm = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _schema = require("./schema");
var _form_fields = require("./form_fields");
var _domain = require("../../../common/types/domain");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Form -> API
const formSerializer = ({
  key,
  label,
  type,
  options
}) => {
  return {
    key,
    label,
    type,
    required: options !== null && options !== void 0 && options.required ? options.required : false
  };
};

// API -> Form
const formDeserializer = ({
  key,
  label,
  type,
  required
}) => {
  return {
    key,
    options: {
      required: Boolean(required)
    },
    label,
    type
  };
};
const FormComponent = ({
  onChange,
  initialValue
}) => {
  const keyDefaultValue = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialValue !== null && initialValue !== void 0 ? initialValue : {
      key: keyDefaultValue,
      label: '',
      type: _domain.CustomFieldTypes.TEXT,
      required: false
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    serializer: formSerializer,
    deserializer: formDeserializer
  });
  const {
    submit,
    isValid,
    isSubmitting
  } = form;
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid,
        submit
      });
    }
  }, [onChange, isValid, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_form_fields.FormFields, {
    isSubmitting: isSubmitting,
    isEditMode: Boolean(initialValue)
  }));
};
FormComponent.displayName = 'CustomFieldsForm';
const CustomFieldsForm = /*#__PURE__*/_react.default.memo(FormComponent);
exports.CustomFieldsForm = CustomFieldsForm;