"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncAlertsToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const SyncAlertsToggleComponent = ({
  isLoading
}) => {
  const [{
    syncAlerts
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['syncAlerts']
  });
  return /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "syncAlerts",
    componentProps: {
      idAria: 'caseSyncAlerts',
      'data-test-subj': 'caseSyncAlerts',
      label: i18n.SYNC_ALERTS_LABEL,
      euiFieldProps: {
        disabled: isLoading,
        label: syncAlerts ? i18n.SYNC_ALERTS_SWITCH_LABEL_ON : i18n.SYNC_ALERTS_SWITCH_LABEL_OFF
      }
    }
  });
};
SyncAlertsToggleComponent.displayName = 'SyncAlertsToggleComponent';
const SyncAlertsToggle = /*#__PURE__*/(0, _react.memo)(SyncAlertsToggleComponent);
exports.SyncAlertsToggle = SyncAlertsToggle;