"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFormFields = exports.CreateCaseForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _title = require("./title");
var _description = require("./description");
var _tags = require("./tags");
var _connector = require("./connector");
var i18n = _interopRequireWildcard(require("./translations"));
var _sync_alerts_toggle = require("./sync_alerts_toggle");
var _timeline_context = require("../timeline_context");
var _insert_timeline = require("../insert_timeline");
var _utils = require("../utils");
var _utils2 = require("../markdown_editor/utils");
var _submit_button = require("./submit_button");
var _form_context = require("./form_context");
var _use_cases_features = require("../../common/use_cases_features");
var _owner_selector = require("./owner_selector");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_available_owners = require("../app/use_available_owners");
var _severity = require("./severity");
var _assignees = require("./assignees");
var _use_cancel_creation_action = require("./use_cancel_creation_action");
var _cancel_creation_confirmation_modal = require("./cancel_creation_confirmation_modal");
var _category = require("./category");
var _custom_fields = require("./custom_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div.attrs(props => props)`
  ${({
  big,
  theme
}) => {
  var _theme$eui$euiSizeXL, _theme$eui, _theme$eui$euiSize, _theme$eui2;
  return (0, _styledComponents.css)`
    margin-top: ${big ? (_theme$eui$euiSizeXL = (_theme$eui = theme.eui) === null || _theme$eui === void 0 ? void 0 : _theme$eui.euiSizeXL) !== null && _theme$eui$euiSizeXL !== void 0 ? _theme$eui$euiSizeXL : '32px' : (_theme$eui$euiSize = (_theme$eui2 = theme.eui) === null || _theme$eui2 === void 0 ? void 0 : _theme$eui2.euiSize) !== null && _theme$eui$euiSize !== void 0 ? _theme$eui$euiSize : '16px'};
  `;
}}
`;
const MySpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  position: absolute;
  top: 50%;
  left: 50%;
  z-index: 99;
`;
const empty = [];
const CreateCaseFormFields = /*#__PURE__*/_react.default.memo(({
  connectors,
  isLoadingConnectors,
  withSteps,
  owner,
  draftStorageKey,
  customFieldsConfiguration,
  isLoadingCaseConfiguration
}) => {
  const {
    isSubmitting
  } = (0, _hook_form_lib.useFormContext)();
  const {
    isSyncAlertsEnabled,
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const canShowCaseSolutionSelection = !owner.length && availableOwners.length > 1;
  const firstStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_ONE_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_title.Title, {
      isLoading: isSubmitting
    }), caseAssignmentAuthorized ? /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
      isLoading: isSubmitting
    })) : null, /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_category.Category, {
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_severity.Severity, {
      isLoading: isSubmitting
    })), canShowCaseSolutionSelection && /*#__PURE__*/_react.default.createElement(Container, {
      big: true
    }, /*#__PURE__*/_react.default.createElement(_owner_selector.CreateCaseOwnerSelector, {
      availableOwners: availableOwners,
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement(Container, {
      big: true
    }, /*#__PURE__*/_react.default.createElement(_description.Description, {
      isLoading: isSubmitting,
      draftStorageKey: draftStorageKey
    })), /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
      isLoading: isSubmitting || isLoadingCaseConfiguration,
      customFieldsConfiguration: customFieldsConfiguration
    })), /*#__PURE__*/_react.default.createElement(Container, null))
  }), [isSubmitting, caseAssignmentAuthorized, canShowCaseSolutionSelection, availableOwners, draftStorageKey, customFieldsConfiguration, isLoadingCaseConfiguration]);
  const secondStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_TWO_TITLE,
    children: /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_sync_alerts_toggle.SyncAlertsToggle, {
      isLoading: isSubmitting
    }))
  }), [isSubmitting]);
  const thirdStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_THREE_TITLE,
    children: /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_connector.Connector, {
      connectors: connectors,
      isLoadingConnectors: isLoadingConnectors,
      isLoading: isSubmitting
    }))
  }), [connectors, isLoadingConnectors, isSubmitting]);
  const allSteps = (0, _react.useMemo)(() => [firstStep, ...(isSyncAlertsEnabled ? [secondStep] : []), thirdStep], [isSyncAlertsEnabled, firstStep, secondStep, thirdStep]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSubmitting && /*#__PURE__*/_react.default.createElement(MySpinner, {
    "data-test-subj": "create-case-loading-spinner",
    size: "xl"
  }), withSteps ? /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: allSteps,
    "data-test-subj": 'case-creation-form-steps'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, firstStep.children, isSyncAlertsEnabled && secondStep.children, thirdStep.children));
});
exports.CreateCaseFormFields = CreateCaseFormFields;
CreateCaseFormFields.displayName = 'CreateCaseFormFields';
const CreateCaseForm = /*#__PURE__*/_react.default.memo(({
  withSteps = true,
  afterCaseCreated,
  onCancel,
  onSuccess,
  timelineIntegration,
  attachments,
  initialValue
}) => {
  const {
    owner,
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const draftStorageKey = (0, _utils2.getMarkdownEditorStorageKey)(appId, 'createCase', 'description');
  const handleOnConfirmationCallback = () => {
    onCancel();
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  };
  const {
    showConfirmationModal,
    onOpenModal,
    onConfirmModal,
    onCancelModal
  } = (0, _use_cancel_creation_action.useCancelCreationAction)({
    onConfirmationCallback: handleOnConfirmationCallback
  });
  const handleOnSuccess = theCase => {
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
    return onSuccess(theCase);
  };
  return /*#__PURE__*/_react.default.createElement(_timeline_context.CasesTimelineIntegrationProvider, {
    timelineIntegration: timelineIntegration
  }, /*#__PURE__*/_react.default.createElement(_form_context.FormContext, {
    afterCaseCreated: afterCaseCreated,
    onSuccess: handleOnSuccess,
    attachments: attachments,
    initialValue: initialValue
  }, /*#__PURE__*/_react.default.createElement(CreateCaseFormFields, {
    connectors: empty,
    customFieldsConfiguration: [],
    isLoadingConnectors: false,
    isLoadingCaseConfiguration: false,
    withSteps: withSteps,
    owner: owner,
    draftStorageKey: draftStorageKey
  }), /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "create-case-cancel",
    iconType: "cross",
    onClick: onOpenModal,
    size: "s"
  }, i18n.CANCEL), showConfirmationModal && /*#__PURE__*/_react.default.createElement(_cancel_creation_confirmation_modal.CancelCreationConfirmationModal, {
    title: i18n.MODAL_TITLE,
    onConfirm: onConfirmModal,
    onCancel: onCancelModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitCaseButton, null)))), /*#__PURE__*/_react.default.createElement(_insert_timeline.InsertTimeline, {
    fieldName: _description.fieldName
  })));
});
exports.CreateCaseForm = CreateCaseForm;
CreateCaseForm.displayName = 'CreateCaseForm';