"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIssues = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_toast = require("../../../common/use_cases_toast");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_DEBOUNCE_MS = 500;
const useGetIssues = ({
  http,
  actionConnector,
  query
}) => {
  var _actionConnector$id;
  const [debouncedQuery, setDebouncedQuery] = (0, _react.useState)(query);
  (0, _useDebounce.default)(() => {
    setDebouncedQuery(query);
  }, SEARCH_DEBOUNCE_MS, [query]);
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.connectorsQueriesKeys.jiraGetIssues((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '', debouncedQuery !== null && debouncedQuery !== void 0 ? debouncedQuery : ''), ({
    signal
  }) => {
    var _actionConnector$id2;
    return (0, _api.getIssues)({
      http,
      signal,
      connectorId: (_actionConnector$id2 = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id2 !== void 0 ? _actionConnector$id2 : '',
      title: query !== null && query !== void 0 ? query : ''
    });
  }, {
    enabled: Boolean(actionConnector) && !(0, _lodash.isEmpty)(query),
    staleTime: 60 * 1000,
    // one minute
    onSuccess: res => {
      if (res.status && res.status === 'error') {
        var _res$serviceMessage;
        showErrorToast(new Error(i18n.ISSUES_API_ERROR), {
          title: i18n.ISSUES_API_ERROR,
          toastMessage: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
        });
      }
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ISSUES_API_ERROR
      });
    }
  });
};
exports.useGetIssues = useGetIssues;