"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  EDIT_CATEGORIES_ARIA: true,
  EMPTY_CATEGORY_VALIDATION_MSG: true,
  REMOVE_CATEGORY: true,
  REMOVE_CATEGORY_ARIA_LABEL: true
};
exports.REMOVE_CATEGORY_ARIA_LABEL = exports.REMOVE_CATEGORY = exports.EMPTY_CATEGORY_VALIDATION_MSG = exports.EDIT_CATEGORIES_ARIA = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDIT_CATEGORIES_ARIA = _i18n.i18n.translate('xpack.cases.caseView.editCategoriesLinkAria', {
  defaultMessage: 'click to edit categories'
});
exports.EDIT_CATEGORIES_ARIA = EDIT_CATEGORIES_ARIA;
const EMPTY_CATEGORY_VALIDATION_MSG = _i18n.i18n.translate('xpack.cases.caseView.emptyCategoryValidationMsg', {
  defaultMessage: 'Empty category is not allowed'
});
exports.EMPTY_CATEGORY_VALIDATION_MSG = EMPTY_CATEGORY_VALIDATION_MSG;
const REMOVE_CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.removeCategory', {
  defaultMessage: 'Remove category'
});
exports.REMOVE_CATEGORY = REMOVE_CATEGORY;
const REMOVE_CATEGORY_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.caseView.removeCategoryAriaLabel', {
  defaultMessage: 'click to remove category'
});
exports.REMOVE_CATEGORY_ARIA_LABEL = REMOVE_CATEGORY_ARIA_LABEL;