"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CasesProvider = exports.CasesContext = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useDeepCompareEffect = _interopRequireDefault(require("react-use/lib/useDeepCompareEffect"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _reactQuery = require("@tanstack/react-query");
var _cases_global_components = require("./cases_global_components");
var _constants = require("../../../common/constants");
var _files = require("../../../common/files");
var _navigation = require("../../common/navigation");
var _use_application = require("./use_application");
var _cases_context_reducer = require("./cases_context_reducer");
var _files2 = require("../../files");
var _query_client = require("./query_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesContext = /*#__PURE__*/_react.default.createContext(undefined);
exports.CasesContext = CasesContext;
const CasesProvider = ({
  children,
  value: {
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    owner,
    permissions,
    basePath = _navigation.DEFAULT_BASE_PATH,
    features = {},
    releasePhase = 'ga',
    getFilesClient
  }
}) => {
  const {
    appId,
    appTitle
  } = (0, _use_application.useApplication)();
  const [state, dispatch] = (0, _react.useReducer)(_cases_context_reducer.casesContextReducer, (0, _cases_context_reducer.getInitialCasesContextState)());
  const [value, setValue] = (0, _react.useState)(() => ({
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    owner,
    permissions,
    basePath,
    /**
     * The empty object at the beginning avoids the mutation
     * of the DEFAULT_FEATURES object
     */
    features: (0, _lodash.merge)({}, _constants.DEFAULT_FEATURES, features),
    releasePhase,
    dispatch
  }));

  /**
   * Only update the context if the nested permissions fields changed, this avoids a rerender when the object's reference
   * changes.
   */
  (0, _useDeepCompareEffect.default)(() => {
    setValue(prev => ({
      ...prev,
      permissions
    }));
  }, [permissions]);

  /**
   * `appId` and `appTitle` are dynamically retrieved from kibana context.
   * We need to update the state if any of these values change, the rest of props are never updated.
   */
  (0, _react.useEffect)(() => {
    if (appId && appTitle) {
      setValue(prev => ({
        ...prev,
        appId,
        appTitle
      }));
    }
  }, [appTitle, appId]);
  const applyFilesContext = (0, _react.useCallback)(contextChildren => {
    if (owner.length === 0) {
      return contextChildren;
    }
    if ((0, _files2.isRegisteredOwner)(owner[0])) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
        client: getFilesClient((0, _files.constructFileKindIdByOwner)(owner[0]))
      }, contextChildren);
    } else {
      throw new Error('Invalid owner provided to cases context. See https://github.com/elastic/kibana/blob/main/x-pack/plugins/cases/README.md#casescontext-setup');
    }
  }, [getFilesClient, owner]);
  return isCasesContextValue(value) ? /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.casesQueryClient
  }, /*#__PURE__*/_react.default.createElement(CasesContext.Provider, {
    value: value
  }, applyFilesContext( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cases_global_components.CasesGlobalComponents, {
    state: state
  }), children)))) : null;
};
exports.CasesProvider = CasesProvider;
CasesProvider.displayName = 'CasesProvider';
function isCasesContextValue(value) {
  return value.appId != null && value.appTitle != null && value.permissions != null;
}

// eslint-disable-next-line import/no-default-export
var _default = CasesProvider;
exports.default = _default;