"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestUsersPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _userProfileComponents = require("@kbn/user-profile-components");
var _eui = require("@elastic/eui");
var _use_is_user_typing = require("../../../common/use_is_user_typing");
var _constants = require("../../../../common/constants");
var _use_suggest_user_profiles = require("../../../containers/user_profiles/use_suggest_user_profiles");
var _use_cases_context = require("../../cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("../translations"));
var _sort = require("../../user_profiles/sort");
var _empty_message = require("../../user_profiles/empty_message");
var _no_matches = require("../../user_profiles/no_matches");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverButton = ({
  togglePopover,
  isDisabled
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "left",
  content: i18n.EDIT_ASSIGNEES
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "data-test-subj": "case-view-assignees-edit-button",
  "aria-label": i18n.EDIT_ASSIGNEES_ARIA_LABEL,
  iconType: 'pencil',
  onClick: togglePopover,
  disabled: isDisabled
}));
PopoverButton.displayName = 'PopoverButton';
const SuggestUsersPopoverComponent = ({
  assignedUsersWithProfiles,
  currentUserProfile,
  isLoading,
  isPopoverOpen,
  onUsersChange,
  togglePopover,
  onClosePopover
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const selectedProfiles = (0, _react.useMemo)(() => {
    return (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, assignedUsersWithProfiles.map(assignee => ({
      ...assignee.profile
    })));
  }, [assignedUsersWithProfiles, currentUserProfile]);
  const [selectedUsers, setSelectedUsers] = (0, _react.useState)();
  const onChange = (0, _react.useCallback)(users => {
    const sortedUsers = (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, users);
    setSelectedUsers(sortedUsers);
    onUsersChange(sortedUsers !== null && sortedUsers !== void 0 ? sortedUsers : []);
  }, [currentUserProfile, onUsersChange]);
  const selectedStatusMessage = (0, _react.useCallback)(selectedCount => i18n.TOTAL_USERS_ASSIGNED(selectedCount), []);
  const limitReachedMessage = (0, _react.useCallback)(limit => i18n.MAX_SELECTED_ASSIGNEES(limit), []);
  const {
    data: userProfiles,
    isLoading: isLoadingSuggest,
    isFetching: isFetchingSuggest
  } = (0, _use_suggest_user_profiles.useSuggestUserProfiles)({
    name: searchTerm,
    owners: owner,
    onDebounce
  });
  const isLoadingData = isLoadingSuggest || isLoading || isFetchingSuggest || isUserTyping;
  const isDisabled = isLoading;
  const searchResultProfiles = (0, _react.useMemo)(() => (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles), [currentUserProfile, userProfiles]);
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesPopover, {
    title: i18n.EDIT_ASSIGNEES,
    button: /*#__PURE__*/_react.default.createElement(PopoverButton, {
      togglePopover: togglePopover,
      isDisabled: isDisabled
    }),
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    panelStyle: {
      minWidth: 520
    },
    selectableProps: {
      onChange,
      onSearchChange: term => {
        setSearchTerm(term);
        onContentChange(term);
      },
      selectedStatusMessage,
      options: searchResultProfiles,
      selectedOptions: selectedUsers !== null && selectedUsers !== void 0 ? selectedUsers : selectedProfiles,
      isLoading: isLoadingData,
      height: 'full',
      limit: _constants.MAX_ASSIGNEES_PER_CASE,
      limitReachedMessage,
      searchPlaceholder: i18n.SEARCH_USERS,
      clearButtonLabel: i18n.REMOVE_ASSIGNEES,
      emptyMessage: /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, null),
      noMatchesMessage: !isLoadingData ? /*#__PURE__*/_react.default.createElement(_no_matches.NoMatches, null) : /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, null)
    }
  });
};
SuggestUsersPopoverComponent.displayName = 'SuggestUsersPopover';
const SuggestUsersPopover = /*#__PURE__*/_react.default.memo(SuggestUsersPopoverComponent);
exports.SuggestUsersPopover = SuggestUsersPopover;