"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = exports.EditTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _fp = require("lodash/fp");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("../../tags/translations"));
var _use_get_tags = require("../../../containers/use_get_tags");
var _tags = require("../../tags/tags");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _schema = require("../../create/schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = {
  tags: _schema.schemaTags
};
exports.schema = schema;
const CommonUseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const MyFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    width: 100%;
    p {
      font-size: ${theme.eui.euiSizeM};
      margin-block-end: unset;
    }
  `}
`;
const ColumnFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    & {
      max-width: 100%;
      @media only screen and (max-width: ${theme.eui.euiBreakpoints.m}) {
        flex-direction: row;
      }
    }
  `}
`;
const EditTags = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onSubmit,
  tags
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const initialState = {
    tags
  };
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema
  });
  const {
    submit
  } = form;
  const [isEditTags, setIsEditTags] = (0, _react.useState)(false);
  const onSubmitTags = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: newData
    } = await submit();
    if (isValid && newData.tags) {
      const trimmedTags = newData.tags.map(tag => tag.trim());
      onSubmit(trimmedTags);
      form.reset({
        defaultValue: newData
      });
      setIsEditTags(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onSubmit, submit]);
  const {
    data: tagOptions = []
  } = (0, _use_get_tags.useGetTags)();
  const [options, setOptions] = (0, _react.useState)(tagOptions.map(label => ({
    label
  })));
  (0, _react.useEffect)(() => setOptions(tagOptions.map(label => ({
    label
  }))), [tagOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "case-view-tag-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.TAGS)), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "tag-list-loading"
  }), !isLoading && permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "tag-list-edit",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "tag-list-edit-button",
    "aria-label": i18n.EDIT_TAGS_ARIA,
    iconType: 'pencil',
    onClick: setIsEditTags.bind(null, true)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(MyFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "case-tags"
  }, tags.length === 0 && !isEditTags && /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "no-tags"
  }, i18n.NO_TAGS), !isEditTags && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    tags: tags,
    color: "hollow"
  })), isEditTags && /*#__PURE__*/_react.default.createElement(ColumnFlexGroup, {
    "data-test-subj": "edit-tags",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "tags",
    componentProps: {
      idAria: 'caseTags',
      'data-test-subj': 'caseTags',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        options,
        noSuggestions: false,
        customOptionText: i18n.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.FormDataProvider, {
    pathsToWatch: "tags"
  }, ({
    tags: anotherTags
  }) => {
    const current = options.map(opt => opt.label);
    const newOptions = anotherTags.reduce((acc, item) => {
      if (!acc.includes(item)) {
        return [...acc, item];
      }
      return acc;
    }, current);
    if (!(0, _fp.isEqual)(current, newOptions)) {
      setOptions(newOptions.map(label => ({
        label
      })));
    }
    return null;
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "edit-tags-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitTags,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-tags-cancel",
    iconType: "cross",
    onClick: setIsEditTags.bind(null, false),
    size: "s"
  }, i18n.CANCEL))))))));
});
exports.EditTags = EditTags;
EditTags.displayName = 'EditTags';