"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseCallouts = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_license = require("../../common/use_license");
var _platinum_callout = require("./platinum_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseCalloutsComponent = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  return !isAtLeastPlatinum() ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: {
      marginBottom: euiTheme.size.l
    },
    "data-test-subj": "case-callouts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_platinum_callout.PlatinumLicenseCallout, null))) : null;
};
CaseCalloutsComponent.displayName = 'CaseCalloutsComponent';
const CaseCallouts = /*#__PURE__*/_react.default.memo(CaseCalloutsComponent);
exports.CaseCallouts = CaseCallouts;