"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeLegacyValuesFromOptions = exports.getStorableFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const notAll = option => option !== 'all';

/**
 * In earlier versions, the options 'status' and 'severity' could have a value of 'all'.
 * This function ensures such legacy values are removed from the URL parameters to maintain
 * backwards compatibility.
 */
const removeLegacyValuesFromOptions = ({
  status: legacyStatus,
  severity: legacySeverity
}) => {
  return {
    status: legacyStatus.filter(notAll).filter(Boolean),
    severity: legacySeverity.filter(notAll).filter(Boolean)
  };
};
exports.removeLegacyValuesFromOptions = removeLegacyValuesFromOptions;
const getStorableFilters = filterOptions => {
  const {
    status,
    severity
  } = filterOptions;
  return {
    severity,
    status
  };
};
exports.getStorableFilters = getStorableFilters;