"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumnsConfiguration = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../common/translations");
var _use_cases_features = require("../../common/use_cases_features");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesColumnsConfiguration = isSelectorView => {
  const {
    isAlertsEnabled,
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: {
      customFields
    }
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const canDisplayDefault = true;
  const result = {
    title: {
      field: 'title',
      name: i18n.NAME,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    assignees: {
      field: 'assignees',
      name: i18n.ASSIGNEES,
      canDisplay: caseAssignmentAuthorized && !isSelectorView,
      isCheckedDefault: true
    },
    tags: {
      field: 'tags',
      name: i18n.TAGS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    totalAlerts: {
      field: 'totalAlerts',
      name: _translations2.ALERTS,
      canDisplay: isAlertsEnabled && !isSelectorView,
      isCheckedDefault: true
    },
    totalComment: {
      field: 'totalComment',
      name: i18n.COMMENTS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    category: {
      field: 'category',
      name: i18n.CATEGORY,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    closedAt: {
      field: 'closedAt',
      name: i18n.CLOSED_ON,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: false
    },
    createdAt: {
      field: 'createdAt',
      name: i18n.CREATED_ON,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    updatedAt: {
      field: 'updatedAt',
      name: i18n.UPDATED_ON,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    externalIncident: {
      field: 'externalIncident',
      name: i18n.EXTERNAL_INCIDENT,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    status: {
      field: 'status',
      name: i18n.STATUS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    severity: {
      field: 'severity',
      name: i18n.SEVERITY,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    }
  };

  // we need to extend the configuration with the customFields
  customFields.forEach(({
    key,
    label
  }) => {
    result[key] = {
      field: key,
      name: label,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: false
    };
  });
  return result;
};
exports.useCasesColumnsConfiguration = useCasesColumnsConfiguration;