"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    & {
      @media only screen and (max-width: ${theme.eui.euiBreakpoints.s}) {
        flex-direction: column;
      }
    }
  `}
`;
const NavButtons = ({
  actionsErrors
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToCreateCase();
  }, [navigateToCreateCase]);
  if (!permissions.create && !permissions.settings) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ButtonFlexGroup, {
    responsive: false
  }, permissions.settings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.ConfigureCaseButton, {
    label: i18n.CONFIGURE_CASES_BUTTON,
    showToolTip: !(0, _fp.isEmpty)(actionsErrors),
    msgTooltip: !(0, _fp.isEmpty)(actionsErrors) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionsErrors[0].description) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    titleTooltip: !(0, _fp.isEmpty)(actionsErrors) ? actionsErrors[0].title : ''
  })), permissions.create && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    fill: true,
    onClick: navigateToCreateCaseClick,
    href: getCreateCaseUrl(),
    iconType: "plusInCircle",
    "data-test-subj": "createNewCaseBtn"
  }, i18n.CREATE_CASE_TITLE))));
};
exports.NavButtons = NavButtons;
NavButtons.displayName = 'NavButtons';