"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AllCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _navigation = require("../../common/navigation");
var _use_get_action_license = require("../../containers/use_get_action_license");
var _case_callouts = require("../callouts/case_callouts");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _helpers = require("../use_push_to_service/helpers");
var _all_cases_list = require("./all_cases_list");
var _header = require("./header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AllCases = () => {
  (0, _use_breadcrumbs.useCasesBreadcrumbs)(_navigation.CasesDeepLinkId.cases);
  const {
    data: actionLicense = null
  } = (0, _use_get_action_license.useGetActionLicense)();
  const actionsErrors = (0, _react.useMemo)(() => (0, _helpers.getActionLicenseError)(actionLicense), [actionLicense]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_case_callouts.CaseCallouts, null), /*#__PURE__*/_react.default.createElement(_header.CasesTableHeader, {
    actionsErrors: actionsErrors
  }), /*#__PURE__*/_react.default.createElement(_all_cases_list.AllCasesList, null));
};
exports.default = exports.AllCases = AllCases;
AllCases.displayName = 'AllCases';

// eslint-disable-next-line import/no-default-export