"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestUserProfilesRequestRt = exports.GetCaseUsersResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _v = require("../../domain/user/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetCaseUsersResponseRt = rt.strict({
  assignees: rt.array(_v.UserWithProfileInfoRt),
  unassignedUsers: rt.array(_v.UserWithProfileInfoRt),
  participants: rt.array(_v.UserWithProfileInfoRt),
  reporter: _v.UserWithProfileInfoRt
});
exports.GetCaseUsersResponseRt = GetCaseUsersResponseRt;
/**
 * User Profiles
 */
const SuggestUserProfilesRequestRt = rt.intersection([rt.strict({
  name: rt.string,
  owners: rt.array(rt.string)
}), rt.exact(rt.partial({
  size: (0, _schema.limitedNumberSchema)({
    fieldName: 'size',
    min: 1,
    max: _constants.MAX_SUGGESTED_PROFILES
  })
}))]);
exports.SuggestUserProfilesRequestRt = SuggestUserProfilesRequestRt;