"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = exports.GetConfigurationFindRequestRt = exports.CustomFieldsConfigurationRt = exports.CustomFieldConfigurationWithoutTypeRt = exports.ConfigurationRequestRt = exports.ConfigurationPatchRequestRt = exports.CaseConfigureRequestParamsRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _domain = require("../../domain");
var _v = require("../../domain/configure/v1");
var _v2 = require("../../domain/connector/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldConfigurationWithoutTypeRt = rt.strict({
  /**
   * key of custom field
   */
  key: (0, _schema.regexStringRt)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'key',
      min: 1,
      max: _constants.MAX_CUSTOM_FIELD_KEY_LENGTH
    }),
    pattern: '^[a-z0-9_-]+$',
    message: `Key must be lower case, a-z, 0-9, '_', and '-' are allowed`
  }),
  /**
   * label of custom field
   */
  label: (0, _schema.limitedStringSchema)({
    fieldName: 'label',
    min: 1,
    max: _constants.MAX_CUSTOM_FIELD_LABEL_LENGTH
  }),
  /**
   * custom field options - required
   */
  required: rt.boolean
});
exports.CustomFieldConfigurationWithoutTypeRt = CustomFieldConfigurationWithoutTypeRt;
const TextCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _domain.CustomFieldTextTypeRt
}), CustomFieldConfigurationWithoutTypeRt]);
exports.TextCustomFieldConfigurationRt = TextCustomFieldConfigurationRt;
const ToggleCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _domain.CustomFieldToggleTypeRt
}), CustomFieldConfigurationWithoutTypeRt]);
exports.ToggleCustomFieldConfigurationRt = ToggleCustomFieldConfigurationRt;
const CustomFieldsConfigurationRt = (0, _schema.limitedArraySchema)({
  codec: rt.union([TextCustomFieldConfigurationRt, ToggleCustomFieldConfigurationRt]),
  min: 0,
  max: _constants.MAX_CUSTOM_FIELDS_PER_CASE,
  fieldName: 'customFields'
});
exports.CustomFieldsConfigurationRt = CustomFieldsConfigurationRt;
const ConfigurationRequestRt = rt.intersection([rt.strict({
  /**
   * The external connector
   */
  connector: _v2.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: _v.ClosureTypeRt,
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
}), rt.exact(rt.partial({
  customFields: CustomFieldsConfigurationRt
}))]);
exports.ConfigurationRequestRt = ConfigurationRequestRt;
const GetConfigurationFindRequestRt = rt.exact(rt.partial({
  /**
   * The configuration plugin owner to filter the search by. If this is left empty the results will include all configurations
   * that the user has permissions to access
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
exports.GetConfigurationFindRequestRt = GetConfigurationFindRequestRt;
const CaseConfigureRequestParamsRt = rt.strict({
  configuration_id: rt.string
});
exports.CaseConfigureRequestParamsRt = CaseConfigureRequestParamsRt;
const ConfigurationPatchRequestRt = rt.intersection([rt.exact(rt.partial({
  closure_type: _v.ConfigurationBasicWithoutOwnerRt.type.props.closure_type,
  connector: _v.ConfigurationBasicWithoutOwnerRt.type.props.connector,
  customFields: CustomFieldsConfigurationRt
})), rt.strict({
  version: rt.string
})]);
exports.ConfigurationPatchRequestRt = ConfigurationPatchRequestRt;