"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tooltip_content = require("./tooltip_content");
var _skeleton = require("./skeleton");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CaseTooltipComponent = /*#__PURE__*/_react.default.memo(props => {
  const {
    dataTestSubj,
    children,
    loading = false,
    className = '',
    content
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": dataTestSubj ? dataTestSubj : 'cases-components-tooltip',
    anchorClassName: className,
    content: loading ? /*#__PURE__*/_react.default.createElement(_skeleton.Skeleton, null) : /*#__PURE__*/_react.default.createElement(_tooltip_content.TooltipContent, content)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
});
CaseTooltipComponent.displayName = 'Tooltip';
const Tooltip = /*#__PURE__*/(0, _react.memo)(CaseTooltipComponent);
exports.Tooltip = Tooltip;