"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.middleware = void 0;
var _redux = require("redux");
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _get_window = require("../../lib/get_window");
var _in_flight = require("./in_flight");
var _workpad_update = require("./workpad_update");
var _element_stats = require("./element_stats");
var _resolved_args = require("./resolved_args");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const middlewares = [(0, _redux.applyMiddleware)(_reduxThunk.default, _element_stats.elementStats, _resolved_args.resolvedArgs, _in_flight.inFlight, _workpad_update.workpadUpdate)];

// compose with redux devtools, if extension is installed
const compose = (0, _get_window.getWindow)().__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || _redux.compose;
const middleware = compose(...middlewares);
exports.middleware = middleware;