"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InteractionBoundary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _workpad_app = require("../../workpad_app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This adds a bit of a buffer to make room for scroll bars, etc.
const BUFFER = 24;

/**
 * The `InteractionBoundary` is a simple area which expands beyond the boundaries
 * of the `InteractiveWorkpadPage` to the corners of the `WorkpadApp`, allowing
 * mouse events started outside to fire and be tracked within.
 */
class InteractionBoundary extends _react.PureComponent {
  // Implemented with state, as I think there'll be cases where we want to
  // re-evaluate the size of the interaction boundary in the future.
  constructor() {
    super();
    this.state = {
      height: '0',
      width: '0',
      marginLeft: '0',
      marginTop: '0'
    };
  }
  componentDidMount() {
    const container = $('#' + _workpad_app.WORKPAD_CONTAINER_ID);
    const height = container.height();
    const width = container.width();
    if (height && width) {
      this.setState({
        height: height - BUFFER + 'px',
        width: width - BUFFER + 'px',
        marginLeft: -((width - BUFFER) / 2) + 'px',
        marginTop: -((height - BUFFER) / 2) + 'px'
      });
    }
  }
  render() {
    const style = {
      top: '50%',
      left: '50%',
      position: 'absolute',
      ...this.state
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      id: "canvasInteractionBoundary",
      style: style
    });
  }
}
exports.InteractionBoundary = InteractionBoundary;