"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _time_interval = require("../../../lib/time_interval");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.confirmButtonLabel', {
    defaultMessage: 'Set'
  }),
  getFormDescription: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.formDescription', {
    defaultMessage: 'Use shorthand notation, like {secondsExample}, {minutesExample}, or {hoursExample}',
    values: {
      secondsExample: '30s',
      minutesExample: '10m',
      hoursExample: '1h'
    }
  }),
  getFormLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.formLabel', {
    defaultMessage: 'Set a custom interval'
  })
};
const CustomInterval = ({
  gutterSize,
  buttonSize,
  onSubmit,
  defaultValue
}) => {
  const [customInterval, setCustomInterval] = (0, _react.useState)(defaultValue);
  const refreshInterval = (0, _time_interval.getTimeInterval)(customInterval);
  const isInvalid = Boolean(customInterval.length && !refreshInterval);
  const handleChange = ev => setCustomInterval(ev.target.value);
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: ev => {
      ev.preventDefault();
      if (!isInvalid && refreshInterval) {
        onSubmit(refreshInterval);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: gutterSize
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getFormLabel(),
    helpText: strings.getFormDescription(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    value: customInterval,
    onChange: handleChange,
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isInvalid,
    size: buttonSize,
    type: "submit",
    minWidth: "auto"
  }, strings.getButtonLabel())))));
};
exports.CustomInterval = CustomInterval;
CustomInterval.propTypes = {
  buttonSize: _propTypes.default.string,
  gutterSize: _propTypes.default.string,
  defaultValue: _propTypes.default.string,
  onSubmit: _propTypes.default.func.isRequired
};
CustomInterval.defaultProps = {
  buttonSize: 's',
  gutterSize: 's',
  defaultValue: ''
};