"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getEditorMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.solutionToolbar.editorMenuButtonLabel', {
    defaultMessage: 'Select type'
  })
};
const EditorMenu = ({
  factories,
  promotedVisTypes,
  visTypeAliases,
  createNewVisType,
  createNewEmbeddable
}) => {
  const factoryGroupMap = {};
  const ungroupedFactories = [];
  let panelCount = 1;

  // Maps factories with a group to create nested context menus for each group type
  // and pushes ungrouped factories into a separate array
  factories.forEach((factory, index) => {
    const {
      grouping
    } = factory;
    if (grouping) {
      grouping.forEach(group => {
        if (factoryGroupMap[group.id]) {
          factoryGroupMap[group.id].factories.push(factory);
        } else {
          factoryGroupMap[group.id] = {
            id: group.id,
            appName: group.getDisplayName ? group.getDisplayName({}) : group.id,
            icon: group.getIconType ? group.getIconType({}) : 'empty',
            factories: [factory],
            panelId: panelCount
          };
          panelCount++;
        }
      });
    } else {
      ungroupedFactories.push(factory);
    }
  });
  const getVisTypeMenuItem = visType => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty'
    } = visType;
    return {
      name: titleInWizard || title,
      icon: icon,
      onClick: createNewVisType(visType),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getVisTypeAliasMenuItem = visTypeAlias => {
    const {
      name,
      title,
      description,
      icon = 'empty'
    } = visTypeAlias;
    return {
      name: title,
      icon,
      onClick: createNewVisType(visTypeAlias),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getEmbeddableFactoryMenuItem = factory => {
    const icon = factory !== null && factory !== void 0 && factory.getIconType ? factory.getIconType() : 'empty';
    const toolTipContent = factory !== null && factory !== void 0 && factory.getDescription ? factory.getDescription() : undefined;
    return {
      name: factory.getDisplayName(),
      icon,
      toolTipContent,
      onClick: createNewEmbeddable(factory),
      'data-test-subj': `createNew-${factory.type}`
    };
  };
  const editorMenuPanels = [{
    id: 0,
    items: [...visTypeAliases.map(getVisTypeAliasMenuItem), ...Object.values(factoryGroupMap).map(({
      id,
      appName,
      icon,
      panelId
    }) => ({
      name: appName,
      icon,
      panel: panelId,
      'data-test-subj': `canvasEditorMenu-${id}Group`
    })), ...ungroupedFactories.map(getEmbeddableFactoryMenuItem), ...promotedVisTypes.map(getVisTypeMenuItem)]
  }, ...Object.values(factoryGroupMap).map(({
    appName,
    panelId,
    factories: groupFactories
  }) => ({
    id: panelId,
    title: appName,
    items: groupFactories.map(getEmbeddableFactoryMenuItem)
  }))];
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    ownFocus: true,
    label: strings.getEditorMenuButtonLabel(),
    panelPaddingSize: "none",
    "data-test-subj": "canvasEditorMenuButton"
  }, () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: editorMenuPanels,
    "data-test-subj": "canvasEditorContextMenu"
  }));
};
exports.EditorMenu = EditorMenu;