"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedElementsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _clone_subgraphs = require("../../lib/clone_subgraphs");
var _services = require("../../services");
var _transient = require("../../state/actions/transient");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _ui_metric = require("../../lib/ui_metric");
var _saved_elements_modal = require("./saved_elements_modal.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

const customElementAdded = 'elements-custom-added';
const SavedElementsModal = ({
  onClose
}) => {
  const notifyService = (0, _services.useNotifyService)();
  const customElementService = (0, _services.useCustomElementService)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const pageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const [customElements, setCustomElements] = (0, _react.useState)([]);
  const onSearch = async (search = '') => {
    try {
      const {
        customElements: foundElements
      } = await customElementService.find(search);
      setCustomElements(foundElements);
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't find custom elements`
      });
    }
  };
  const onAddCustomElement = customElement => {
    const {
      selectedNodes = []
    } = JSON.parse(customElement.content) || {};
    const clonedNodes = selectedNodes && (0, _clone_subgraphs.cloneSubgraphs)(selectedNodes);
    if (clonedNodes) {
      dispatch((0, _elements.insertNodes)(clonedNodes, pageId)); // first clone and persist the new node(s)
      dispatch((0, _transient.selectToplevelNodes)(clonedNodes.filter(e => !e.position.parent).map(e => e.id))); // then select the cloned node(s)
    }

    onClose();
    (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.LOADED, customElementAdded);
  };
  const onRemoveCustomElement = async id => {
    try {
      await customElementService.remove(id);
      await onSearch();
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't delete custom elements`
      });
    }
  };
  const onUpdateCustomElement = async (id, name, description, image) => {
    try {
      await customElementService.update(id, {
        name: (0, _lodash.camelCase)(name),
        displayName: name,
        image,
        help: description
      });
      await onSearch();
    } catch (err) {
      notifyService.error(err, {
        title: `Couldn't update custom elements`
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_saved_elements_modal.SavedElementsModal, {
    onAddCustomElement,
    onClose,
    onRemoveCustomElement,
    onSearch,
    onUpdateCustomElement,
    customElements
  });
};
exports.SavedElementsModal = SavedElementsModal;