"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageConfig = void 0;
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _transitions_registry = require("../../lib/transitions_registry");
var _workpad = require("../../state/selectors/workpad");
var _pages = require("../../state/actions/pages");
var _page_config = require("./page_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getNoTransitionDropDownOptionLabel: () => _i18n.i18n.translate('xpack.canvas.pageConfig.transitions.noneDropDownOptionLabel', {
    defaultMessage: 'None',
    description: 'This is the option the user should choose if they do not want any page transition (i.e. fade in, fade out, etc) to ' + 'be applied to the current page.'
  })
};
const mapStateToProps = state => {
  const pageIndex = (0, _workpad.getSelectedPageIndex)(state);
  const page = (0, _workpad.getPages)(state)[pageIndex];
  return {
    page,
    pageIndex
  };
};
const mapDispatchToProps = {
  stylePage: _pages.stylePage,
  setPageTransition: _pages.setPageTransition
};
const mergeProps = (stateProps, dispatchProps) => {
  return {
    pageIndex: stateProps.pageIndex,
    setBackground: background => {
      const itsTheNewStyle = {
        ...stateProps.page.style,
        background
      };
      dispatchProps.stylePage(stateProps.page.id, itsTheNewStyle);
    },
    background: (0, _lodash.get)(stateProps, 'page.style.background'),
    transition: _transitions_registry.transitionsRegistry.get((0, _lodash.get)(stateProps, 'page.transition.name')),
    transitions: [{
      value: '',
      text: strings.getNoTransitionDropDownOptionLabel()
    }].concat(_transitions_registry.transitionsRegistry.toArray().map(({
      name,
      displayName
    }) => ({
      value: name,
      text: displayName
    }))),
    setTransition: name => {
      dispatchProps.setPageTransition(stateProps.page.id, {
        name
      });
    }
  };
};
const PageConfig = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(_page_config.PageConfig);
exports.PageConfig = PageConfig;