"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadDropzone = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../../../i18n");
var _hooks = require("../hooks");
var _upload_dropzone = require("./upload_dropzone.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  WorkpadDropzone: errors
} = _i18n.ErrorStrings;
const UploadDropzone = ({
  children
}) => {
  const notify = (0, _services.useNotifyService)();
  const uploadWorkpad = (0, _hooks.useImportWorkpad)();
  const [isDisabled, setIsDisabled] = (0, _react.useState)(false);
  const onDrop = files => {
    if (!files) {
      return;
    }
    if (files.length > 1) {
      notify.warning(errors.getTooManyFilesErrorMessage());
      return;
    }
    setIsDisabled(true);
    uploadWorkpad(files[0], () => setIsDisabled(false));
  };
  return /*#__PURE__*/_react.default.createElement(_upload_dropzone.UploadDropzone, {
    disabled: isDisabled,
    onDrop
  }, children);
};
exports.UploadDropzone = UploadDropzone;