"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindWorkpads = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindWorkpads = () => {
  const workpadService = (0, _services.useWorkpadService)();
  const notifyService = (0, _services.useNotifyService)();
  return (0, _react.useCallback)(async (text = '') => {
    try {
      return await workpadService.find(text);
    } catch (err) {
      notifyService.error(err, {
        title: errors.getFindFailureErrorMessage()
      });
    }
  }, [notifyService, workpadService]);
};
exports.useFindWorkpads = useFindWorkpads;
const errors = {
  getFindFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.useFindWorkpads.findFailureErrorMessage', {
    defaultMessage: `Couldn't find workpad`
  })
};