"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _error_boundary = require("../enhance/error_boundary");
var _arg_simple_form = require("./arg_simple_form");
var _arg_template_form = require("./arg_template_form");
var _simple_failure = require("./simple_failure");
var _advanced_failure = require("./advanced_failure");
var _arg_label = require("./arg_label");
var _pending_arg_value = require("./pending_arg_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPending = (argTypeInstance, resolvedArgValue) => {
  const {
    argType
  } = argTypeInstance;

  // arg does not need to be resolved, no need to branch
  if (!argType.resolveArgValue) {
    return false;
  }

  // arg needs to be resolved, render pending if the value is not defined
  return typeof resolvedArgValue === 'undefined';
};

// This is what is being generated by render() from the Arg class. It is called in FunctionForm
const ArgForm = props => {
  const {
    argId,
    argTypeInstance,
    templateProps,
    valueMissing,
    label,
    setLabel,
    onValueRemove,
    workpad,
    assets,
    resolvedArgValue
  } = props;
  const [renderError, setRenderError] = (0, _react.useState)(false);
  const isMounted = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  if (isPending(argTypeInstance, resolvedArgValue)) {
    return /*#__PURE__*/_react.default.createElement(_pending_arg_value.PendingArgValue, props);
  }
  return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, null, ({
    error,
    resetErrorState
  }) => {
    const {
      template,
      simpleTemplate
    } = argTypeInstance.argType;
    const hasError = Boolean(error) || renderError;
    const argumentProps = {
      ...templateProps,
      resolvedArgValue,
      defaultValue: argTypeInstance.default,
      renderError: () => {
        // Provide templates with a renderError method, and wrap the error in a known error type
        // to stop Kibana's window.error from being called
        isMounted.current && setRenderError(true);
      },
      error: hasError,
      setLabel: label => isMounted.current && setLabel(label),
      resetErrorState: () => {
        resetErrorState();
        isMounted.current && setRenderError(false);
      },
      label,
      workpad,
      argId,
      assets
    };
    const expandableLabel = Boolean(hasError || template);
    const simpleArg = /*#__PURE__*/_react.default.createElement(_arg_simple_form.ArgSimpleForm, {
      required: argTypeInstance.required,
      valueMissing: valueMissing,
      onRemove: onValueRemove
    }, /*#__PURE__*/_react.default.createElement(_arg_template_form.ArgTemplateForm, {
      template: simpleTemplate,
      errorTemplate: _simple_failure.SimpleFailure,
      error: hasError,
      argumentProps: argumentProps
    }));
    const extendedArg = /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasArg--controls"
    }, /*#__PURE__*/_react.default.createElement(_arg_template_form.ArgTemplateForm, {
      template: template,
      errorTemplate: _advanced_failure.AdvancedFailure,
      error: hasError,
      argumentProps: argumentProps
    }));
    return /*#__PURE__*/_react.default.createElement("div", {
      className: `canvasArg ${expandableLabel ? 'canvasSidebar__expandable' : null}`
    }, /*#__PURE__*/_react.default.createElement(_arg_label.ArgLabel, {
      className: "resolved",
      argId: argId,
      label: label,
      help: argTypeInstance.help,
      expandable: expandableLabel,
      simpleArg: simpleArg,
      initialIsOpen: !simpleTemplate
    }, extendedArg));
  });
};
exports.ArgForm = ArgForm;
ArgForm.propTypes = {
  argId: _propTypes.default.string.isRequired,
  workpad: _propTypes.default.object.isRequired,
  argTypeInstance: _propTypes.default.shape({
    argType: _propTypes.default.object.isRequired,
    help: _propTypes.default.string.isRequired,
    required: _propTypes.default.bool,
    default: _propTypes.default.any
  }).isRequired,
  templateProps: _propTypes.default.object,
  valueMissing: _propTypes.default.bool,
  label: _propTypes.default.string,
  setLabel: _propTypes.default.func.isRequired,
  expand: _propTypes.default.bool,
  setExpand: _propTypes.default.func,
  onValueRemove: _propTypes.default.func,
  resolvedArgValue: _propTypes.default.any
};