"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BfetchRequestError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Error thrown when xhr request fails
 * @public
 */
class BfetchRequestError extends Error {
  /**
   * constructor
   * @param code - Xhr error code
   */
  constructor(code) {
    const message = code === 0 ? _i18n.i18n.translate('bfetch.networkError', {
      defaultMessage: 'Check your network connection and try again.'
    }) : _i18n.i18n.translate('bfetch.networkErrorWithStatus', {
      defaultMessage: 'Check your network connection and try again. Code {code}',
      values: {
        code
      }
    });
    super(message);
    (0, _defineProperty2.default)(this, "code", void 0);
    this.name = 'BfetchRequestError';
    this.code = code;
  }
}
exports.BfetchRequestError = BfetchRequestError;