"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceTransactionStats = getServiceTransactionStats;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../../common/es_fields/apm");
var _transaction_types = require("../../../../common/transaction_types");
var _environment_query = require("../../../../common/utils/environment_query");
var _calculate_throughput = require("../../../lib/helpers/calculate_throughput");
var _transactions = require("../../../lib/helpers/transactions");
var _transaction_error_rate = require("../../../lib/helpers/transaction_error_rate");
var _maybe = require("../../../../common/utils/maybe");
var _service_group_query_with_overflow = require("../../../lib/service_group_query_with_overflow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceTransactionStats({
  environment,
  kuery,
  apmEventClient,
  maxNumServices,
  start,
  end,
  serviceGroup,
  randomSampler,
  documentType,
  rollupInterval,
  useDurationSummary
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const outcomes = (0, _transaction_error_rate.getOutcomeAggregation)(documentType);
  const metrics = {
    avg_duration: {
      avg: {
        field: (0, _transactions.getDurationFieldForTransactions)(documentType, useDurationSummary)
      }
    },
    ...outcomes
  };
  const response = await apmEventClient.search('get_service_transaction_stats', {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _service_group_query_with_overflow.serviceGroupWithOverflowQuery)(serviceGroup)]
        }
      },
      aggs: {
        sample: {
          random_sampler: randomSampler,
          aggs: {
            overflowCount: {
              sum: {
                field: _apm.SERVICE_OVERFLOW_COUNT
              }
            },
            services: {
              terms: {
                field: _apm.SERVICE_NAME,
                size: maxNumServices
              },
              aggs: {
                transactionType: {
                  terms: {
                    field: _apm.TRANSACTION_TYPE
                  },
                  aggs: {
                    ...metrics,
                    environments: {
                      terms: {
                        field: _apm.SERVICE_ENVIRONMENT
                      }
                    },
                    sample: {
                      top_metrics: {
                        metrics: [{
                          field: _apm.AGENT_NAME
                        }],
                        sort: {
                          '@timestamp': 'desc'
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  });
  return {
    serviceStats: (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.sample.services.buckets.map(bucket => {
      var _bucket$transactionTy, _topTransactionTypeBu;
      const topTransactionTypeBucket = (0, _maybe.maybe)((_bucket$transactionTy = bucket.transactionType.buckets.find(({
        key
      }) => (0, _transaction_types.isDefaultTransactionType)(key))) !== null && _bucket$transactionTy !== void 0 ? _bucket$transactionTy : bucket.transactionType.buckets[0]);
      return {
        serviceName: bucket.key,
        transactionType: topTransactionTypeBucket === null || topTransactionTypeBucket === void 0 ? void 0 : topTransactionTypeBucket.key,
        environments: (_topTransactionTypeBu = topTransactionTypeBucket === null || topTransactionTypeBucket === void 0 ? void 0 : topTransactionTypeBucket.environments.buckets.map(environmentBucket => environmentBucket.key)) !== null && _topTransactionTypeBu !== void 0 ? _topTransactionTypeBu : [],
        agentName: topTransactionTypeBucket === null || topTransactionTypeBucket === void 0 ? void 0 : topTransactionTypeBucket.sample.top[0].metrics[_apm.AGENT_NAME],
        latency: topTransactionTypeBucket === null || topTransactionTypeBucket === void 0 ? void 0 : topTransactionTypeBucket.avg_duration.value,
        transactionErrorRate: topTransactionTypeBucket ? (0, _transaction_error_rate.calculateFailedTransactionRate)(topTransactionTypeBucket) : undefined,
        throughput: topTransactionTypeBucket ? (0, _calculate_throughput.calculateThroughputWithRange)({
          start,
          end,
          value: topTransactionTypeBucket === null || topTransactionTypeBucket === void 0 ? void 0 : topTransactionTypeBucket.doc_count
        }) : undefined
      };
    })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [],
    serviceOverflowCount: ((_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.sample) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.overflowCount.value) || 0
  };
}