"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rumVariables = exports.rumScript = exports.rumLineNumbers = exports.rumHighlightLang = exports.rum = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rumVariables = {
  apmServiceName: 'serviceName',
  apmServerUrl: 'serverUrl',
  apmServiceVersion: 'serviceVersion',
  apmEnvironment: 'environment'
};
exports.rumVariables = rumVariables;
const rumHighlightLang = 'js';
exports.rumHighlightLang = rumHighlightLang;
const rumServiceVersionHint = _i18n.i18n.translate('xpack.apm.tutorial.jsClient.installDependency.commands.setServiceVersionComment', {
  defaultMessage: 'Set the service version (required for source map feature)'
});
const rumLineNumbers = {
  start: 1,
  highlight: '3, 5, 7, 9',
  annotations: {
    3: _shared_hints.serviceNameHint,
    5: _shared_hints.serverUrlHint,
    7: rumServiceVersionHint,
    9: _shared_hints.serviceEnvironmentHint
  }
};
exports.rumLineNumbers = rumLineNumbers;
const rum = `import { init as initApm } from '@elastic/apm-rum'
var apm = initApm({
  ${rumVariables.apmServiceName}: '{{{apmServiceName}}}',

  ${rumVariables.apmServerUrl}: '{{{apmServerUrl}}}',

  serviceVersion: '',

  ${rumVariables.apmEnvironment}: '{{{apmEnvironment}}}'
})`;
exports.rum = rum;
const rumScript = `\
<script src="https://your-cdn-host.com/path/to/elastic-apm-rum.umd.min.js" crossorigin></script>
<script>
  elasticApm.init({
    ${rumVariables.apmServiceName}: '{{{apmServiceName}}}',
    ${rumVariables.apmServerUrl}: '{{{apmServerUrl}}}',
  })
</script>
`;
exports.rumScript = rumScript;