"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureCatalogueEntry = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featureCatalogueEntry = {
  id: 'apm',
  title: 'APM',
  description: _i18n.i18n.translate('xpack.apm.apmDescription', {
    defaultMessage: 'Automatically collect in-depth performance metrics and ' + 'errors from inside your applications.'
  }),
  icon: 'apmApp',
  path: '/app/apm',
  showOnHomePage: false,
  category: 'data'
};
exports.featureCatalogueEntry = featureCatalogueEntry;