"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPopoverAndFlyout = AlertingPopoverAndFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alerting_flyout = require("../../../alerting/ui_components/alerting_flyout");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.alerts', {
  defaultMessage: 'Alerts and rules'
});
const transactionDurationLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.transactionDuration', {
  defaultMessage: 'Latency'
});
const transactionErrorRateLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.transactionErrorRate', {
  defaultMessage: 'Failed transaction rate'
});
const errorCountLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.errorCount', {
  defaultMessage: ' Create error count rule'
});
const createThresholdAlertLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.createThresholdAlert', {
  defaultMessage: 'Create threshold rule'
});
const createAnomalyAlertAlertLabel = _i18n.i18n.translate('xpack.apm.home.alertsMenu.createAnomalyAlert', {
  defaultMessage: 'Create anomaly rule'
});
const CREATE_THRESHOLD_PANEL_ID = 'create_threshold_panel';
function AlertingPopoverAndFlyout({
  canSaveAlerts,
  canReadAlerts,
  canReadMlJobs
}) {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [ruleType, setRuleType] = (0, _react.useState)(null);
  const {
    plugins: {
      observability
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(prevState => !prevState),
    "data-test-subj": "apmAlertAndRulesHeaderLink"
  }, alertLabel);
  const panels = [{
    id: 0,
    title: alertLabel,
    items: [...(canSaveAlerts ? [{
      name: createThresholdAlertLabel,
      panel: CREATE_THRESHOLD_PANEL_ID,
      'data-test-subj': 'apmAlertsMenuItemCreateThreshold'
    }, ...(canReadMlJobs ? [{
      name: createAnomalyAlertAlertLabel,
      onClick: () => {
        setRuleType(_ruleDataUtils.ApmRuleType.Anomaly);
        setPopoverOpen(false);
      },
      'data-test-subj': 'apmAlertsMenuItemCreateAnomaly'
    }] : []), {
      name: errorCountLabel,
      onClick: () => {
        setRuleType(_ruleDataUtils.ApmRuleType.ErrorCount);
        setPopoverOpen(false);
      },
      'data-test-subj': 'apmAlertsMenuItemErrorCount'
    }] : []), ...(canReadAlerts ? [{
      name: _i18n.i18n.translate('xpack.apm.home.alertsMenu.viewActiveAlerts', {
        defaultMessage: 'Manage rules'
      }),
      href: observability.useRulesLink().href,
      icon: 'tableOfContents',
      'data-test-subj': 'apmAlertsMenuItemManageRules'
    }] : [])]
  },
  // Threshold panel
  {
    id: CREATE_THRESHOLD_PANEL_ID,
    title: createThresholdAlertLabel,
    items: [
    // Latency
    {
      name: transactionDurationLabel,
      onClick: () => {
        setRuleType(_ruleDataUtils.ApmRuleType.TransactionDuration);
        setPopoverOpen(false);
      }
    },
    // Throughput *** TO BE ADDED ***
    // Failed transactions rate
    {
      name: transactionErrorRateLabel,
      onClick: () => {
        setRuleType(_ruleDataUtils.ApmRuleType.TransactionErrorRate);
        setPopoverOpen(false);
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "integrations-menu",
    button: button,
    isOpen: popoverOpen,
    closePopover: () => setPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })), /*#__PURE__*/_react.default.createElement(_alerting_flyout.AlertingFlyout, {
    ruleType: ruleType,
    addFlyoutVisible: !!ruleType,
    setAddFlyoutVisibility: visible => {
      if (!visible) {
        setRuleType(null);
      }
    }
  }));
}