"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorerWaterfall = TraceExplorerWaterfall;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _url_helpers = require("../../shared/links/url_helpers");
var _use_waterfall_fetcher = require("../transaction_details/use_waterfall_fetcher");
var _waterfall_with_summary = require("../transaction_details/waterfall_with_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceExplorerWaterfall() {
  var _waterfallFetchResult;
  const history = (0, _reactRouterDom.useHistory)();
  const traceSamplesFetchResult = (0, _use_trace_explorer_samples.useTraceExplorerSamples)();
  const {
    query: {
      traceId,
      transactionId,
      waterfallItemId,
      rangeFrom,
      rangeTo,
      environment,
      showCriticalPath,
      detailTab
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer/waterfall');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  (0, _react.useEffect)(() => {
    var _traceSamplesFetchRes, _nextSample$traceId, _nextSample$transacti;
    const nextSample = (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples[0];
    const nextWaterfallItemId = '';
    (0, _url_helpers.replace)(history, {
      query: {
        traceId: (_nextSample$traceId = nextSample === null || nextSample === void 0 ? void 0 : nextSample.traceId) !== null && _nextSample$traceId !== void 0 ? _nextSample$traceId : '',
        transactionId: (_nextSample$transacti = nextSample === null || nextSample === void 0 ? void 0 : nextSample.transactionId) !== null && _nextSample$transacti !== void 0 ? _nextSample$transacti : '',
        waterfallItemId: nextWaterfallItemId
      }
    });
  }, [traceSamplesFetchResult.data, history]);
  const waterfallFetchResult = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId,
    transactionId,
    start,
    end
  });
  return /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    waterfallFetchResult: waterfallFetchResult,
    traceSamples: traceSamplesFetchResult.data.traceSamples,
    traceSamplesFetchStatus: traceSamplesFetchResult.status,
    environment: environment,
    onSampleClick: sample => {
      (0, _url_helpers.push)(history, {
        query: {
          traceId: sample.traceId,
          transactionId: sample.transactionId,
          waterfallItemId: ''
        }
      });
    },
    onTabClick: nextDetailTab => {
      (0, _url_helpers.push)(history, {
        query: {
          detailTab: nextDetailTab
        }
      });
    },
    detailTab: detailTab,
    waterfallItemId: waterfallItemId,
    serviceName: (_waterfallFetchResult = waterfallFetchResult.waterfall.entryWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.doc.service.name,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: nextShowCriticalPath => {
      (0, _url_helpers.push)(history, {
        query: {
          showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
        }
      });
    }
  });
}