"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMenuSections = getMenuSections;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _observability_logs_link = require("../../../../shared/links/observability_logs_link");
var _infra_link = require("../../../../shared/links/infra_link");
var _sections_helper = require("../../../../shared/transaction_action_menu/sections_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInfraMetricsQuery(timestamp) {
  if (!timestamp) {
    return {
      from: 0,
      to: 0
    };
  }
  const timeInMilliseconds = new Date(timestamp).getTime();
  const fiveMinutes = _moment.default.duration(5, 'minutes').asMilliseconds();
  return {
    from: timeInMilliseconds - fiveMinutes,
    to: timeInMilliseconds + fiveMinutes
  };
}
function getMenuSections({
  instanceDetails,
  basePath,
  onFilterByInstanceClick,
  metricsHref,
  allDatasetsLocator,
  nodeLogsLocator
}) {
  var _instanceDetails$kube, _instanceDetails$kube2, _instanceDetails$cont;
  const podId = (_instanceDetails$kube = instanceDetails.kubernetes) === null || _instanceDetails$kube === void 0 ? void 0 : (_instanceDetails$kube2 = _instanceDetails$kube.pod) === null || _instanceDetails$kube2 === void 0 ? void 0 : _instanceDetails$kube2.uid;
  const containerId = (_instanceDetails$cont = instanceDetails.container) === null || _instanceDetails$cont === void 0 ? void 0 : _instanceDetails$cont.id;
  const time = instanceDetails['@timestamp'] ? new Date(instanceDetails['@timestamp']).valueOf() : undefined;
  const infraMetricsQuery = getInfraMetricsQuery(instanceDetails['@timestamp']);
  const podLogsHref = (0, _observability_logs_link.getNodeLogsHref)('pod', podId, time, allDatasetsLocator, nodeLogsLocator);
  const containerLogsHref = (0, _observability_logs_link.getNodeLogsHref)('container', containerId, time, allDatasetsLocator, nodeLogsLocator);
  const podActions = [{
    key: 'podLogs',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.podLogs', {
      defaultMessage: 'Pod logs'
    }),
    href: podLogsHref,
    condition: !!podId
  }, {
    key: 'podMetrics',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.podMetrics', {
      defaultMessage: 'Pod metrics'
    }),
    href: (0, _infra_link.getInfraHref)({
      app: 'metrics',
      basePath,
      path: `/link-to/pod-detail/${podId}`,
      query: infraMetricsQuery
    }),
    condition: !!podId
  }];
  const containerActions = [{
    key: 'containerLogs',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.containerLogs', {
      defaultMessage: 'Container logs'
    }),
    href: containerLogsHref,
    condition: !!containerId
  }, {
    key: 'containerMetrics',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.containerMetrics', {
      defaultMessage: 'Container metrics'
    }),
    href: (0, _infra_link.getInfraHref)({
      app: 'metrics',
      basePath,
      path: `/link-to/container-detail/${containerId}`,
      query: infraMetricsQuery
    }),
    condition: !!containerId
  }];
  const apmActions = [{
    key: 'filterByInstance',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.filterByInstance', {
      defaultMessage: 'Filter overview by instance'
    }),
    onClick: onFilterByInstanceClick,
    condition: true
  }, {
    key: 'analyzeRuntimeMetric',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.metrics', {
      defaultMessage: 'Metrics'
    }),
    href: metricsHref,
    condition: true
  }];
  const sectionRecord = {
    observability: [{
      key: 'podDetails',
      title: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.pod.title', {
        defaultMessage: 'Pod details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.pod.subtitle', {
        defaultMessage: 'View logs and metrics for this pod to get further details.'
      }),
      actions: podActions
    }, {
      key: 'containerDetails',
      title: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.container.title', {
        defaultMessage: 'Container details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.container.subtitle', {
        defaultMessage: 'View logs and metrics for this container to get further details.'
      }),
      actions: containerActions
    }],
    apm: [{
      key: 'apm',
      actions: apmActions
    }]
  };
  return (0, _sections_helper.getNonEmptySections)(sectionRecord);
}