"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLogs = ServiceLogs;
exports.getInfrastructureKQLFilter = getInfrastructureKQLFilter;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/logs-shared-plugin/public");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _apm = require("../../../../common/es_fields/apm");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceLogs() {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/logs');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/infrastructure_attributes', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end]);
  return /*#__PURE__*/_react.default.createElement(_public.LogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: 'default'
    },
    columns: [{
      type: 'timestamp'
    }, {
      type: 'message'
    }],
    height: '60vh',
    startTimestamp: (0, _moment.default)(start).valueOf(),
    endTimestamp: (0, _moment.default)(end).valueOf(),
    query: getInfrastructureKQLFilter({
      data,
      serviceName,
      environment
    }),
    showFlyoutAction: true
  });
}
function getInfrastructureKQLFilter({
  data,
  serviceName,
  environment
}) {
  var _data$containerIds;
  const serviceNameAndEnvironmentCorrelation = environment === _environment_filter_values.ENVIRONMENT_ALL.value ? `${_apm.SERVICE_NAME}: "${serviceName}"` // correlate on service.name only
  : `(${_apm.SERVICE_NAME}: "${serviceName}" and ${_apm.SERVICE_ENVIRONMENT}: "${environment}") or (${_apm.SERVICE_NAME}: "${serviceName}" and not ${_apm.SERVICE_ENVIRONMENT}: *)`; // correlate on service.name + service.environment

  // correlate on container.id
  const containerIdKql = ((_data$containerIds = data === null || data === void 0 ? void 0 : data.containerIds) !== null && _data$containerIds !== void 0 ? _data$containerIds : []).map(id => `${_apm.CONTAINER_ID}: "${id}"`).join(' or ');
  const containerIdCorrelation = containerIdKql ? [`((${containerIdKql}) and not ${_apm.SERVICE_NAME}: *)`] : [];
  return [serviceNameAndEnvironmentCorrelation, ...containerIdCorrelation].join(' or ');
}